import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.time.LocalDate;
import java.util.ArrayList;

public class PriceListMenu implements Menu {
    BufferedReader br = new BufferedReader(new InputStreamReader(System.in));

    @Override
    public boolean showMenu() throws IOException {
        System.out.println("===============================");
        System.out.println("|       PRICE LIST MENU       |");
        System.out.println("+=============================+");
        System.out.println("| 1. Show all price lists     |");
        System.out.println("| 2. Show a price list        |");
        System.out.println("| 3. Add new price list       |");
        System.out.println("| 4. Edit a price list        |");
        System.out.println("| 5. Delete a price list      |");
        System.out.println("|                             |");
        System.out.println("| 0. Back to main menu        |");
        System.out.println("===============================");
        System.out.println();

        return makeAChoice();
    }

    @Override
    public boolean makeAChoice() throws IOException {
        System.out.print("Your option > ");
        String option = br.readLine().strip();

        try {
            boolean result = true; //nadaval, ak bol pri '0' len return, preto takto
            switch (option) {
                case "1":   showAllPriceLists(); result = true; break;
                case "2":   showPriceList(); result = true; break;
                case "3":   addNewPriceList(); result = true; break;
                case "4":   editPriceList(); result = true; break;
                case "5":   deletePriceList(); result = true; break;
                case "0":   result = false; break;
                default:    System.out.println("Unknown option ..."); result = true; break;
            }

            return result;
            //} catch(SQLException | IOException | InterruptedException e) {
        } catch(SQLException | IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void showAllPriceLists() throws SQLException {
        int count = 0;
        ArrayList<PriceList> customers = PriceList.findAll();
        for(PriceList priceList: customers){
            Printer.print(priceList);
            System.out.println((++count != customers.size() ? "\n" : "\nTotal count of shown price lists: " + count));
        }
    }

    public void showPriceList() throws IOException, SQLException {
        try {
            System.out.println("Enter a price list's ID> ");
            int priceListId = Integer.valueOf(br.readLine().strip());

            PriceList priceList = PriceList.findById(priceListId);

            if (priceList == null) {
                System.out.println("No such price list with ID = " + priceListId + ".");
            } else {
                Printer.print(priceList);
            }
        }
        catch(NumberFormatException e){
            System.out.println("Wrong number format for price list's ID. Try again later.");
        }
    }

    public int addNewPriceList() throws IOException, SQLException {
        try {
            PriceList priceList = new PriceList();

            System.out.println("You are adding new price list ...");
            System.out.println("Child price > ");
            priceList.setChildPrice(new BigDecimal(br.readLine().strip()));
            System.out.println("Student price > ");
            priceList.setStudentPrice(new BigDecimal(br.readLine().strip()));
            System.out.println("Normal price > ");
            priceList.setNormalPrice(new BigDecimal(br.readLine().strip()));
            System.out.println("Senior price > ");
            priceList.setSeniorPrice(new BigDecimal(br.readLine().strip()));

            priceList.insert();

            System.out.println();
            System.out.println("Price list has been succesfully added!");
            System.out.println("Price list's id is: " + priceList.getId());

            return priceList.getId();
        }
        catch(NumberFormatException e){
            System.out.println("Wrong number format for amount. Try again later.");
            return -1;  //osetrit?
        }
    }

    public void editPriceList() throws IOException, SQLException {
        int priceListId = - 1;
        try {
            System.out.println("You are editing a price list ...");
            System.out.println("Enter a price list's ID> ");
            priceListId = Integer.valueOf(br.readLine().strip());
        }
        catch(NumberFormatException e){
            System.out.println("Wrong number format for price list's ID. Try again later.");
        }

        PriceList priceList = PriceList.findById(priceListId);

        try {
            if (priceList == null) {
                System.out.println("No such price list with ID = " + priceListId + ".");
            } else {
                Printer.print(priceList);

                //System.out.println("+-- -- -- - - --- - - -- -- --+");
                System.out.println("New child price > ");
                priceList.setChildPrice(new BigDecimal(br.readLine().strip()));
                System.out.println("New student price > ");
                priceList.setStudentPrice(new BigDecimal(br.readLine().strip()));
                System.out.println("New normal price > ");
                priceList.setNormalPrice(new BigDecimal(br.readLine().strip()));
                System.out.println("New senior price > ");
                priceList.setSeniorPrice(new BigDecimal(br.readLine().strip()));

                priceList.update();

                System.out.println("The price list has been succesfully updated");
            }
        }
        catch(NumberFormatException e){
            System.out.println("Wrong number format for amount. Try again later.");
        }
    }

    public void deletePriceList() throws IOException, SQLException {
        try {
            System.out.println("You are deleting a price list ...");
            System.out.println("Enter a price list's ID> ");
            int priceListId = Integer.valueOf(br.readLine().strip());

            PriceList priceList = PriceList.findById(priceListId);

            if (priceList == null) {
                System.out.println("No such price list with ID = " + priceList + ".");
            } else {
                priceList.delete();

                System.out.println("The price list has been succesfully deleted");
            }
        }
        catch(NumberFormatException e){
            System.out.println("Wrong number format for price list's ID. Try again later.");
        }
    }

    @Override
    public void mainloop() throws IOException {
        try{
            while(showMenu());
        }
        catch(Exception e){
            throw new Error("Something wrong happend ...");
        }
    }
}
