import org.postgresql.jdbc2.ArrayAssistant;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;

public class Printer {

    public static void print(Customer customer){
        System.out.print("Name: " + customer.getFirstName() + " " + customer.getLastName());
        System.out.print(" [" + customer.getId() + "]\n");
        System.out.println("Birth day: " + customer.getBirthDate());
        System.out.println("Account: " + customer.getCredits());
        System.out.println("Points: " + customer.getPoints());
    }

    public static void print(PriceList priceList){
        System.out.println("+-----------------------------+");
        System.out.println("| child price   |" + String.format(" %1$11s " , priceList.getChildPrice()) +"|");
        System.out.println("| student price |" + String.format(" %1$11s " , priceList.getStudentPrice()) +"|");
        System.out.println("| normal price  |" + String.format(" %1$11s " , priceList.getNormalPrice()) +"|");
        System.out.println("| senior price  |" + String.format(" %1$11s " , priceList.getSeniorPrice()) +"|");
        System.out.println("+-----------------------------+");
    }

    public static void print(Event event) throws SQLException {
        System.out.println("+-----------------------------+");
        System.out.println("| Name:" + String.format(" %-21s ", event.getName()) + "|");
        System.out.println("| Date:" + String.format(" %-21s ", event.getEventDate().toString()) + "|");
        System.out.println("| Type:" + String.format(" %-21s ", event.getTypeFullName()) + "|");
        System.out.println("| Sectors: " + String.format(" %-21s ", event.getSectors()) + "|");
        Printer.print(PriceList.findById(event.getPriceListId()));
    }

    public static void printSector(int eventId, int sectorId){
        try {
            printSector(eventId, sectorId, -1);
        } catch (SQLException e) {
            System.out.println("Something go wrong ...");
        }
    }

    public static void printSector(int eventId, int sectorId, int customerId) throws SQLException {
        ArrayList<ArrayList<Place>> places = Place.findBySectorId(sectorId);

        //zistenie max hodnoty v pocte sedadiel
        int maximumCountOfPlaces = 0;
        for(ArrayList<Place> row: places){
            if(maximumCountOfPlaces < row.size()){
                maximumCountOfPlaces = row.size();
            }
        }

        //pocet cifier v cisle 'maximumCountOfPlaces'
        int widthOfMaximumCountOfPlaces = Integer.valueOf(maximumCountOfPlaces).toString().length();

        //vytvorenie pomocnych string cisiel pri printovani
        ArrayList<String> numbers = new ArrayList<>();
        for(int intNumber = 1; intNumber <= maximumCountOfPlaces; intNumber++){
            String stringNumber = Integer.valueOf(intNumber).toString();
            while(stringNumber.length() != Integer.valueOf(maximumCountOfPlaces).toString().length()){
                stringNumber = "0" + stringNumber;
            }
            numbers.add(stringNumber);
        }

        //zistenie poctu radov
        int countOfRows = places.size();
        int width = Integer.valueOf(countOfRows).toString().length();
        int totalWidth = (width + 2) + 2 * maximumCountOfPlaces;


        for(int index = 0; index < widthOfMaximumCountOfPlaces; index++){
            StringBuffer stringRow = new StringBuffer();
            stringRow.append(String.format("%-" + width + "s |", ""));

            for(String number: numbers){
                stringRow.append(number.charAt(index));
                stringRow.append("|");
            }
            System.out.println(stringRow);
        }
        for(int p = 0; p < totalWidth; p++){
            System.out.print((p != totalWidth - 1) ? "-" : "-\n");
        }

        //printovanie obsadenia
        int rowNumber = 1;
        for(ArrayList<Place> row: places){
            StringBuffer stringRow = new StringBuffer();
            stringRow.append(String.format("%-" + width + "s |", rowNumber));

            for(Place place: row){
                if(place.isPlaceFree(eventId)){
                    stringRow.append(" |");
                }
                else{
                    if(customerId != -1 && place.hasCustomerRevervationForEvent(customerId, eventId)){
                        stringRow.append("R|");
                    }
                    else {
                        stringRow.append("X|");
                    }
                }
            }
            System.out.println(stringRow);
            rowNumber++;
        }
    }

    //inline printer funkcie

    public static void printInline(Event event){
        System.out.println("ID = " + String.format("%-4s", event.getId()) + " | " + event.getName() + " (" + event.getEventDate() + ")");
    }

    public static void printInline(Ticket ticket) throws SQLException {
        Place place = Place.findById(ticket.getPlaceId());
        Event event = Event.findById(ticket.getEventId());
        System.out.print("(" + ticket.getId() + ") " + event.getName() + " | ");
        System.out.print("Sektor: " + place.getSectorId() + " ");  //popripade vypytaj si sector a printuj oznacenie;
        System.out.print("Rad: " + place.getRow() + " ");
        System.out.print("Miesto: " + place.getPlace() + " | ");
        System.out.print("Cas: " + event.getEventDate() + " | ");
        System.out.print("Cena: " + ticket.getPrice() + "[" + ticket.getType() +"]\n");
    }
}
