import java.math.BigDecimal;
import java.sql.*;
import java.util.ArrayList;

public class Ticket {
    int id;
    int customerId;
    int eventId;
    int placeId;
    BigDecimal price;
    String type;    //D - detsky, St - studentky, N - normalny, Se - senior
    String state;   //P - permanentka; R - rezervovany; N - kupeny, nepouzity; P - kupeny, pouzity
    Timestamp time;

    //get funkcie
    public int getId() { return id; }
    public int getCustomerId() { return customerId; }
    public int getEventId() { return eventId; }
    public int getPlaceId() { return placeId; }
    public BigDecimal getPrice() { return price; }
    public String getType() { return type; }
    public String getState() { return state; }
    public Timestamp getTime() { return time; }

    //set funkcie
    public void setId(int id) { this.id = id; }
    public void setCustomerId(int customerId) { this.customerId = customerId; }
    public void setEventId(int eventId) { this.eventId = eventId; }
    public void setPlaceId(int placeId) { this.placeId = placeId; }
    public void setPrice(BigDecimal price) { this.price = price; }
    public void setType(String type) { this.type = type; }
    public void setState(String state) { this.state = state; }
    public void setTime(Timestamp time) { this.time = time; }

    //ostatne funkcie

    public void insert() throws SQLException {
        String sql = "INSERT INTO listky (zakaznik_id, akcia_id, miesto_id, cena, typ, stav, cas) VALUES (?,?,?,?,?,?,?)";
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(sql, Statement.RETURN_GENERATED_KEYS)){
            s.setInt(1, customerId);
            s.setInt(2, eventId);
            s.setInt(3, placeId);
            s.setBigDecimal(4, price);
            s.setString(5, type);
            s.setString(6, state);
            s.setTimestamp(7, time);

            s.executeUpdate();

            try(ResultSet r = s.getGeneratedKeys()) {
                r.next();
                id = r.getInt("listok_id");
            }
        }
    }

    public void updateState() throws SQLException {     //nezamykam, bo zamyka funkcia, ktora toto vola
        String sql = "UPDATE listky SET stav = ? WHERE listok_id = ?";
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(sql)){
            s.setString(1, state);
            s.setInt(2, id);

            s.executeUpdate();
        }
        catch(SQLException e){
            throw e;
        }
    }

    public void delete() throws SQLException {
        String sql = "DELETE FROM listky WHERE listok_id = ?";
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(sql)){
            s.setInt(1, id);

            s.executeUpdate();
        }
    }


    //hladacie funkcie
    public static Ticket makeTicketFromResultSet(ResultSet r) throws SQLException {
        Ticket ticket = new Ticket();

        ticket.setId(r.getInt("listok_id"));
        ticket.setCustomerId(r.getInt("zakaznik_id"));
        ticket.setEventId(r.getInt("akcia_id"));
        ticket.setPlaceId(r.getInt("miesto_id"));
        ticket.setPrice(r.getBigDecimal("cena"));
        ticket.setType(r.getString("typ"));
        ticket.setState(r.getString("stav"));
        ticket.setTime(r.getTimestamp("cas"));

        return ticket;
    }

    public static ArrayList<Ticket> findTicketsByCustomerId(int customerId) throws SQLException {
        String sql = "SELECT * FROM listky WHERE zakaznik_id = ? ORDER BY akcia_id";
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(sql)){
            s.setInt(1, customerId);

            try(ResultSet r = s.executeQuery()){
                ArrayList<Ticket> result = new ArrayList<>();

                while(r.next()){
                    result.add(makeTicketFromResultSet(r));
                }

                return result;
            }
        }
    }

    public static ArrayList<Ticket> findTicketsByCustomerIdWithState(int customerId, String state) throws SQLException {
        String sql = "SELECT * FROM listky WHERE zakaznik_id = ? AND stav = ? ORDER BY akcia_id";
        try(PreparedStatement s = DbContext.getConnection().prepareStatement(sql)){
            s.setInt(1, customerId);
            s.setString( 2 , state);

            try(ResultSet r = s.executeQuery()){
                ArrayList<Ticket> result = new ArrayList<>();

                while(r.next()){
                    result.add(makeTicketFromResultSet(r));
                }

                return result;
            }
        }
    }
}
