#include <iostream>
#include <vector>

using namespace std;

class Matica
{
public:
    Matica(int i, int j);
    void Napln(int i, int j, double hodnota);
    double Hodnota(int i, int j);
    void Transpose();
    void Vypis();
private:
    int m;
    int n;
    vector <double> data;
};

Matica::Matica(int i, int j)
{
    data.resize(i*j);
    m=i;
    n=j;
}
void Matica::Napln(int i, int j, double hodnota)
{
    data[n*i+j]=hodnota;
}
double Matica::Hodnota(int i, int j)
{
    return data.at(n*i+j);
}
void Matica::Transpose()
{
    vector <double> tmp(data);
    for(int i=0;i<m;i++)
        for(int j=0;j<n;j++)
            data[m*j+i]=tmp[n*i+j];
    int ii=m;
    m=n;
    n=ii;
}
void Matica::Vypis()
{
    for(int i=0;i<m;i++)
    {
        for(int j=0;j<n;j++)
            cout << Hodnota(i,j) << "\t";
        cout << endl;
    }
 }

int main()
{
    Matica a(2,3);
    for(int i=0;i<2;i++)
        for(int j=0;j<3;j++)
            a.Napln(i, j, 3*i+j);
    a.Vypis();
    a.Transpose();
    cout << endl;
    a.Vypis();

    return 0;
}

