
double MatrixInversion(double (&A)[MAXN][MAXN], int n, double (&AInverse)[MAXN][MAXN])
{
    // A = vstupna matica (n x n)
    // n = rozmer matice A
    // AInverse = inverzna matica (n x n)
    // Tato funkcia invertuje maticu Gauss-Jordanovou eliminaciou.
    // Vracia determinant matice. Ak vrati 0, matica sa neda invertovat.
    // Pozor!!! Povodna matica A sa eliminaciou stane jednotkovou!
    int i, j, iPass, imx, icol, irow;
    double det, temp, pivot, factor;
    det = 1;
    for (i = 0; i < n; i++)
    {
        for (j = 0; j < n; j++)
        {
            AInverse[i][j] = 0;
        }
        AInverse[i][i] = 1;
    }
    // Altualmnym pivotom riadku je iPass.
    // Pre kazdy prechod - najprv najst najvacsi element v stlpci pivota.
    for (iPass = 0; iPass < n; iPass++)
    {
        imx = iPass;
        for (irow = iPass; irow < n; irow++)
        {
            if (fabs(A[irow][iPass]) > fabs(A[imx][iPass])) imx = irow;
        }
        // Vymenit prvky riadku iPass a riadku imx v A aj AInverse.
        // Zmenit znamienko determinantu na opacne pri zamene riadkov
        if (imx != iPass)
        {
            det *= -1;
            for (icol = 0; icol < n; icol++)
            {
                temp = AInverse[iPass][icol];
                AInverse[iPass][icol] = AInverse[imx][icol];
                AInverse[imx][icol] = temp;
                if (icol >= iPass)
                {
                    temp = A[iPass][icol];
                    A[iPass][icol] = A[imx][icol]; A[imx][icol] = temp;
                }
            }
        }
        // Aktualnym pivotom je teraz A[iPass][iPass].
        // Determinant je sucinom pivotov.
        pivot = A[iPass][iPass];
        det = det * pivot;
        if (det == 0)
        {
            return 0;
        }
        for (icol = 0; icol < n; icol++)
        {
            // Normalizovat riadok pivotu delenim hodnotou pivotu.
            AInverse[iPass][icol] = AInverse[iPass][icol] / pivot;
            if (icol >= iPass) A[iPass][icol] = A[iPass][icol] / pivot;
        }
        for (irow = 0; irow < n; irow++)
        // Pricitat nasobok riadku pivotu ku kazdemu riadku.
        // Nasobiaci koeficient sa zvoli tak, ze prvok A v stlpci pivota je 0.
        {
            if (irow != iPass) factor = A[irow][iPass];
            for (icol = 0; icol < n; icol++)
            {
                if (irow != iPass)
                {
                    AInverse[irow][icol] -= factor * AInverse[iPass][icol];
                    A[irow][icol] -= factor * A[iPass][icol];
                }
            }
        }
    }
    return det;
}

