// Arduino a A1302 (02K) lineárny Hallov sensor

// pri pohľade na senzor spredu (na skosenú časť):
// ľavý = +5V - pripojiť na +5V
// stredný = GND - pripojiť na GND
// pravý = analógový vástup - pripojiť na A0

float value;

void setup ()
{
  Serial.begin(9600); // Spustiť sériovú linku do PC
}

void loop ()
{
  value=analogRead(A0); // 0...1023
  Serial.print(value);
  Serial.print("     ");
  value = value - 500;   // nula zhruba v strede (511), zistiť presnú hodnotu meraním bez magnetu
  value = value / 1024 * 5.0;   // previesť číslo ma volty (analógový vstup má rozsah  0 ... 5V)
  value = value / 0.013;  // citlivosť senzora je asi 1.3 mV/gauss = 13 mV/mT = 0.013 V/mT môže byť 0.010 ... 0.016, treba okalibrovať
  
  Serial.print(value,1); // zaokrúhlenie na 1 desatinné miesto (rozlíšenie A/D prevodníka je asi 0.4 mT)
  Serial.println(" mT");
  delay(100); // čakať 100 milisekúnd
}
