// Dallas teplotné čidlo s Arduinom

//pri pohľade na čidlo spredu (na plochu):
// ľavý (alebo čierny u zapuzdreného) - GND 
// stredný (alebo žltý u zapuzdreného) - data (pin 8)
// pravý (alebo červený u zapúzdreného) - +5V

// zavoláme knižnice, ktoré budeme používať
#include <OneWire.h>   //Knižnica OneWire pre 1-Wire zbernicu 
#include <DallasTemperature.h>  // Knižnica DallasTemperature pre komunikáciu s teplomerom

OneWire oneWire(8); //definuje pin 8, kde bude OneWire
DallasTemperature sensor(&oneWire); //pripraví OneWire zbernicu na zvolenom pine


float value; // budeme používať jednu premennú str, typu String

void setup(void)
{

  sensor.begin(); // spustí  zbernicu
  Serial.begin(9600); // spustiť komunikáciu s PC


}

void loop(void){ 
  
    sensor.requestTemperatures();  //zmerať teplotu
    value = sensor.getTempCByIndex(0); //mame iba jeden senzor s indexom 0, jeho hodnotu chceme
    Serial.print(value); 
    Serial.println(" oC");
    delay(100);
}
