// Arduino a meteosenzor BMP180


#include <Wire.h> //štandardná knižnica pre I2C zbernicu zahrnutá pri inštalácii

#include <Adafruit_BMP085_U.h> //Knižnica "Adafruit BMP085 Unified" pre senzory BMP085 a BMP180

#define ALTITUDE 170.0 //Nadmorská výška pozorovateľa v metroch

Adafruit_BMP085_Unified senzor; //vytvorenie objektu pre komunikáciu so senzorom

void setup() {
  Serial.begin(9600); //Spustenie sériovej komunikácie s PC rýchlosťou 9600 bps

 if (senzor.begin()) //Ak sa podarilo inicializovať senzor
    Serial.println("BMP180 úspešne inicializovaný");
  else //Inak zastať naveky
  {
    Serial.println("BMP180 inicializácia zlyhala");
    while (1);
  }
}

void loop() {
  float T, P, p0; //T=teplota, P=atmosférický tlak, p0=tlak redukovaný na hladinu mora s korekciou na teplotu

  Serial.print("Zadaná nadmorská výška: ");
  Serial.print(ALTITUDE, 0);
  Serial.println(" m");


  senzor.getTemperature(&T);
  Serial.print("Teplota: ");
  Serial.print(T, 1);
  Serial.println(" oC"); 

  senzor.getPressure(&P);       
  Serial.print("Atmosférický tlak: ");
  Serial.print(P/100,2);  //prepočet na hPa, zaokrúhlené na 1 desatinné miesto (úroveň šumu)
  Serial.println(" hPa");

   p0 = senzor.seaLevelForAltitude(ALTITUDE, P, T);
   Serial.print("Tlak redukovaný na hladinu mora: ");
   Serial.print(p0/100,2); //prepočet na hPa, zaokrúhlené na 1 desatinné miesto (úroveň šumu)
   Serial.println(" hPa");
   Serial.println("----------------------------------------");
 
  delay(3000);
}
