// Arduino a senzor vlhkosti a teploty DHT22

//Zapojenie senzora pri pohľade spredu (na rebrá)
// ľavý - +5V
// druhý zľava - data (pin 8) - nepotrebuje push-up rezistor!
// tretí zľava - nezapojený
// pravý - GND

#include "DHT.h"  //Názov knižnice je "DHT Sensor library", sama si priinštaluje aj "Adafruit unified sensor"

// OneWire bude na pine 8, senzor DHT22 (vyrába sa aj DHT11 a iné)
DHT dht(8, DHT22); 


float vlhkost; //premenná pre vlhkosť
float teplota; //premenná pre teplotu
                                
void setup()
{
  // zapneme sériovú linku a určíme rýchlosť 9600 baudov
  Serial.begin(9600);   
  // aktivujeme senzor                     
  dht.begin();                                
}

void loop()
{
  vlhkost = dht.readHumidity();  
  teplota = dht.readTemperature();             

  // vypíšeme informácie po sériovej linke do PC
  Serial.print(vlhkost,1);  //zaokrúhlime na 1 desatinné miesto             
  Serial.print(" %      ");
  Serial.print(teplota,1);
  Serial.println(" oC");

  // počkáme 2s, s takou periódou senzor meria
  delay(2000);                              
}
