// Arduino a meteosenzor BMP180 na meranie nadmorskej výšky


#include <Wire.h> //štandardná knižnica pre I2C zbernicu zahrnutá pri inštalácii

#include <Adafruit_BMP085_U.h> //Knižnica "Adafruit BMP085 Unified" pre senzory BMP085 a BMP180

Adafruit_BMP085_Unified senzor; //vytvorenie objektu pre komunikáciu so senzorom
float P0; //referenčný tlak pri spustení programu

void setup() {
  Serial.begin(9600); //Spustenie sériovej komunikácie s PC rýchlosťou 9600 bps

 if (senzor.begin()) //Ak sa podarilo inicializovať senzor
    Serial.println("BMP180 úspešne inicializovaný");
  else //Inak zastať naveky
  {
    Serial.println("BMP180 inicializácia zlyhala");
    while (1);
  }
  float PP=0;
  int i;
  int N=100;
  for(i=0;i<N;i++) //spriemerovanie pre potlačenie šumu
  {
     senzor.getPressure(&P0);     //zmeranie atmosférického tlaku
     PP = PP+P0;
  }
  P0 = PP/N;

  senzor.getPressure(&P0); //získanie referenčného tlaku (nulová výška)
}

void loop() {
  float T, P, H; //T = teplota, P = atmosférický tlak, H = nadmorská výška

    
  H=0;
  int i;
  int N=60;
  for(i=0;i<N;i++) //spriemerovanie pre potlačenie šumu
  {
     senzor.getPressure(&P);     //zmeranie atmosférického tlaku
     H = H+senzor.pressureToAltitude(P0, P); //určenie nadmorskej výšky oproti referenčnej pri spustení programu
  }
  H = H/N;
  Serial.print(H,1); //zaokrúhlené na 1 desatinné miesto (úroveň šumu)
  Serial.println(" m");
 
  delay(10);
}
