.include "syscall.s"
.include "wave_header.s"

.global _start

.section .data
covox:
	.asciz "COVOX LPT Player\n"
help:
	.asciz "Pouzitie: covox [subor.wav]\n"
file_not_opened:
	.asciz "Chyba: Subor sa nepodarilo otvorit.\n"
ioperm_fail:
	.asciz "Chyba: neviem ziskat pristup na paralelny port\n"
read_error:
	.asciz "Chyba pocas citania suboru\n"
memory_low:
	.asciz "Do pamate sa mi nezmestia vsetky data\n"
argc:
	.long 0
argv:
	.long 0
input:
	.long 0
filehandle: 
	.long 0 #precita z prveho parametra
.equ BufSize, 4194304 #4MB

.section .bss
.lcomm buffer, BufSize

.section .text
_start:	
	pushl $covox
	call write_str
	addl $4, %esp

	#skontrolujem, ci mam aspon dva parametre (meno programu a meno suboru)
	xorl %eax, %eax
	incl %eax
	movl %eax, argv #urcuje, ktory argument chcem pouzit
	movl (%esp), %eax
	movl %eax, argc
	xorl %ebx, %ebx
	incl %ebx
	cmpl argc, %ebx
	jne _ioperm
	pushl $help
	call write_str
	addl $4, %esp
	exit $1

_ioperm:
	#spristupnim LPT port
	ioperm $0x378, $1
	xorl %ebx, %ebx
	cmpl %eax, %ebx
	jle _ioperm_ok
	pushl $ioperm_fail
	call write_str
	addl $4, %esp
	exit $1
_ioperm_ok: #nastavim casovac na 125ms
	pushl $125
	call settimer
	addl $4, %esp

_get_filename:
	movl argv, %esi
	movl 4(%esp,%esi,4), %eax #pesunie parameter do input
	movl %eax, input

	pushl input
	call write_str
	addl $4, %esp
	call write_ln

#_file_open:
	fopen input
	#osetrenie chyby pri otvarani
	xorl %ebx, %ebx
	cmpl %eax, %ebx
	jle _file_opened
	pushl $file_not_opened
	call write_str
	addl $4, %esp
	exit $1
_file_opened:
	movl %eax, filehandle

	#precitam hlavicku suboru
	pushl filehandle
	call wave_header
	addl $4, %esp

	call wave_info

	
#file_read:
	#nacitam do buffera SubChunk2
	movl $BufSize, %ebx
	movl SubChunk2Size, %eax
	cmpl %ebx, %eax
	jbe _read_subchunk
	pushl $memory_low
	call write_str
	addl $4, %esp
	movl $BufSize, %eax

_read_subchunk:
	pushl %eax
	pushl $buffer
	pushl filehandle
	call freadall
	addl $12, %esp
	xorl %ebx, %ebx
	cmpl %eax, %ebx
	jle _read_ok
	pushl $read_error
	call write_str
	addl $4, %esp
	exit $1
_read_ok:
	je _file_close
	movl %eax, %esi #counter %ecx je pouzity v delay
	xorl %edi, %edi
	decl %edi
_buffer_loop:	
	incl %edi
	movb buffer(%edi), %al
	movw $0x378, %dx
	outb %al, %dx

	call delay

	cmpl %esi, %edi
	jb _buffer_loop

_file_close:	
	fclose filehandle

	decl argc
	xorl %ebx, %ebx
	incl %ebx
	cmpl argc, %ebx
	je _end
	incl argv
	jmp _get_filename

_end:
	exit $0
