.include "syscall.s"

.global hello, write_str, write_ln, write_long

.section .data
_stdio_hello_message:
	.ascii "Hello\n"
_stdio_ln_message:
	.ascii "\n"
_stdio_tmp:
	.long 0
_tmp:
	.byte 0
.equ nula, 48
	
.section .bss
.lcomm _stdio_str, 32
.lcomm _stdio_str_rev, 32
	
.section .text

.macro _reg_save
	push %eax
	push %ebx
	push %ecx
	push %edx
.endm

.macro _reg_load
	pop %edx
	pop %ecx
	pop %ebx
	pop %eax
.endm

.macro pisreg reg
	_reg_save
	movb \reg, _tmp
	fwrite $1, $_tmp, $1
	_reg_load
.endm

hello:
	_reg_save
	fwrite $1, $_stdio_hello_message, $6
	_reg_load
	ret

write_str:
#vypise null-terminated string zacinajuci na adrese z parametra na stdout
	pushl %ebp
	movl %esp, %ebp

	movl 8(%ebp), %ecx
	movl %ecx, _stdio_tmp
	movl $0, %edi
_write_str_loop:
	movb (%ecx), %dl
	cmpb $0, %dl
	je _write_str_count
	incl %ecx
	incl %edi
	jmp _write_str_loop
_write_str_count:
	#dec %edi #netreba, lebo ratam od nuly 
	fwrite $1, _stdio_tmp, %edi

	movl %ebp, %esp
	popl %ebp
	ret

write_ln:
	fwrite $1, $_stdio_ln_message, $1
	ret

write_long:
	pushl %ebp
	movl %esp, %ebp
	movl 8(%esp), %eax

	xorl %ebx, %ebx
	xorl %edi, %edi
	movl $10, %ecx
_write_long_loop:
	xorl %edx, %edx
	div %ecx
	addl $nula, %edx
	movl %edx, _stdio_str_rev(,%edi,1)
	cmpl %ebx, %eax
	je _write_long_rev
	incl %edi
	jmp _write_long_loop
_write_long_rev:
	xorl %esi, %esi
_write_long_rev_loop:
	movl _stdio_str_rev(,%edi,1), %eax
	movl %eax, _stdio_str(,%esi,1)
	cmpl %ebx, %edi
	je _write_long
	decl %edi
	incl %esi
	jmp _write_long_rev_loop
	
_write_long:
	incl %esi
	movb %bl, _stdio_str(,%esi,1) #\0
	pushl $_stdio_str
	call write_str
	addl $4, %esp

	movl %ebp, %esp
	popl %ebp
	ret
