.section .data
_syscall_fd:
	.long 0
_syscall_buf:
	.long 0
_syscall_count:
	.long 0
.section .text

.macro exit hodnota
	movl $1, %eax
	movl \hodnota, %ebx
	int $0x80
.endm

.macro gettimeofday TZ
	movl $78, %eax
	movl \TZ, %ebx
	xorl %ecx, %ecx
	int $0x80
.endm

.macro fread filehandle buffer bytes
	movl $3, %eax
	movl \filehandle, %ebx
	movl \buffer, %ecx
	movl \bytes, %edx
	int $0x80
.endm

#freadall fd, buffer, bytes
freadall:
	pushl %ebp
	movl %esp, %ebp
	movl 8(%ebp), %eax
	movl %eax,_syscall_fd
	movl 12(%ebp), %eax
	movl %eax, _syscall_buf
	movl 16(%esp), %eax
	movl %eax, _syscall_count #v _syscall_count mam pocet este neprecitanych bytov
_freadall_loop:
	fread _syscall_fd _syscall_buf _syscall_count
	xorl %ebx, %ebx
	cmpl %eax, %ebx
	jge _freadall_end #nastala chyba alebo koniec suboru, vratim hodnotu v %eax
	subl %eax, _syscall_count
	addl %eax, _syscall_buf
	cmpl _syscall_count, %ebx
	jne _freadall_loop #pokracujem, kym neprecitam vsetko
	movl 16(%esp), %eax #vsetko je uspesne nacitane
_freadall_end:
	movl %ebp, %esp
	popl %ebp
	ret

.macro fwrite filehandle buffer bytes
	movl $4, %eax
	movl \filehandle, %ebx
	movl \buffer, %ecx
	movl \bytes, %edx
	int $0x80
.endm

.macro fopen file
	movl $5, %eax
	movl \file, %ebx
	movl $0, %ecx #citanie
	movl $0666, %edx #prava
	int $0x80
.endm

.macro fclose filehandle
	movl $6, %eax
	movl \filehandle, %ebx
	int $0x80
.endm

.macro ioperm from num mode=$1
	movl $0x65, %eax
	movl \from, %ebx
	movl \num, %ecx
	movl \mode, %edx
	int $0x80
.endm

.macro enable_delay
	ioperm $0x80, $1
.endm

.macro delay usec
	movl \usec, %ecx
	xorl %eax, %eax
	xorl %ebx, %ebx
	movw $0x80, %dx
1:
	outb %al, %dx
	decl %ecx
	cmpl %ecx, %ebx
	jne 1b
.endm
