.section .data
wave_fail:
	.asciz "Nepodporovany typ suboru\n"
wave_format:
	.asciz "--> Nekomprimovane PCM audio, "
wave_bits:
	.asciz " bitov, "
wave_Hz:
	.asciz " Hz, "
wave_channels:
	.asciz " kanalove\n--> velkost zvukovych dat: "
wave_size:
	.asciz " bytov\n"
WaveFD: #filedescriptor
	.long 0 
ChunkID:
	.long 0x46464952 #"RIFF"
Format:
	.long 0x45564157 #"WAVE"
SubChunk1ID:
	.long 0x20746d66 #"fmt "
SubChunk2ID:
	.long 0x61746164 #"data"
AudioFormat:
	.long 0
BitsPerSample:
	.long 0
NumChannels:
	.long 0
SampleRate:
	.long 0
BlockAlign:
	.long 0
SubChunk2Size:
	.long 0
HeaderOK:
	.byte 1 #flag, ci je hlavicka v poriadku
.section .bss
.lcomm header, 44

.section .text

#spracuje informacie z hlavicky subora, ak nie je spravny format, vrati -1
wave_header:
	pushl %ebp
	movl %esp, %ebp
	movl 8(%esp), %eax
	movl %eax, WaveFD

	#nacitam 44 bytovu hlavicku
	pushl $44
	pushl $header
	pushl WaveFD
	call freadall
	addl $12, %esp
	xorl %ebx, %ebx
	cmpl %eax, %ebx
	jle _header_read_ok
	pushl $read_error
	call write_str
	exit $1
_header_read_ok:

#kontrola jednotlivych identifikatorov
	xorl %ebx, %ebx 
_chunkid:
	movl header, %eax
	cmpl %eax, ChunkID
	je _format
	movb %bl, HeaderOK
_format:
	movl $8, %edx
	movl header(%edx), %eax
	cmpl %eax, Format
	je _subchunk1id
	movb %bl, HeaderOK
_subchunk1id:
	movl $12, %edx
	movl header(%edx), %eax
	cmpl %eax, SubChunk1ID
	je _subchunk2id
	movb %bl, HeaderOK
_subchunk2id:
	movl $36, %edx
	movl header(%edx), %eax
	cmpl %eax, SubChunk2ID
	je _header_check
	movb %bl, HeaderOK

_header_check:
	cmpb HeaderOK, %bl
	jne _format_ok
_wave_fail:
	pushl $wave_fail
	call write_str
	addl $4, %esp
	exit $1

_format_ok:
	xorl %eax, %eax
	movl $20, %edx
	movw header(%edx), %ax
	movl %eax, AudioFormat
	decl %eax
	cmpl %eax, %ebx #ak nie je 1, je to komprimovane, to nechcem
	jne _wave_fail

	incl %edx
	incl %edx
	movw header(%edx), %ax
	movl %eax, NumChannels

	cmpl $2, NumChannels
	ja _wave_fail

	incl %edx
	incl %edx
	movl header(%edx), %eax
	movl %eax, SampleRate

	xorl %eax, %eax
	movl $32, %edx
	movw header(%edx), %ax
	movl %eax, BlockAlign

	decl %eax
	cmpl %ebx, %eax #ak je viac ako 1 byt/sample, nechcem
	jne _wave_fail

	incl %edx
	incl %edx
	movw header(%edx), %ax
	movl %eax, BitsPerSample

	movl $40, %edx
	movl header(%edx), %eax
	movl %eax, SubChunk2Size

	movl %ebp, %esp
	popl %ebp
	ret

#vypise informacie o wave subore
wave_info:
	pushl $wave_format
	call write_str
	addl $4, %esp
		
	pushl BitsPerSample
	call write_long
	addl $4, %esp

	pushl $wave_bits
	call write_str
	addl $4, %esp
	
	pushl SampleRate
	call write_long
	addl $4, %esp

	pushl $wave_Hz
	call write_str
	addl $4, %esp

	pushl NumChannels
	call write_long
	addl $4, %esp

	pushl $wave_channels
	call write_str
	addl $4, %esp

	pushl SubChunk2Size
	call write_long
	addl $4, %esp

	pushl $wave_size
	call write_str
	addl $4, %esp

	ret
