/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;

public class Plotter
extends Canvas {
    int sizeY = 500;
    int sizeX = 500;
    double cursorX = 0.0;
    double cursorY = 0.0;
    double rangeX = 0.0;
    double rangeY = 0.0;
    double minX = 0.0;
    double minY = 0.0;
    double maxX = 0.0;
    double maxY = 0.0;
    double originX = 0.0;
    double originY = 0.0;
    Graphics2D g2;

    Plotter() {
    }

    public void paint(Graphics graphics) {
        this.g2 = (Graphics2D)graphics;
        this.g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        this.plot();
    }

    public void setScale(double d, double d2, double d3, double d4) {
        this.minX = d;
        this.maxX = d2;
        this.minY = d4;
        this.maxY = d3;
        this.rangeX = this.maxX - this.minX;
        this.rangeY = this.maxY - this.minY;
        this.originX = -this.minX * (double)this.sizeX / this.rangeX;
        this.originY = -this.minY * (double)this.sizeY / this.rangeY;
    }

    public void drawAxis() {
        this.g2.draw(new Line2D.Double(this.originX, 0.0, this.originX, this.sizeY));
        this.g2.draw(new Line2D.Double(0.0, this.originY, this.sizeY, this.originY));
    }

    public void drawGrid() {
        double d;
        this.g2.setColor(Color.cyan);
        for (d = 0.0; d <= (double)this.sizeX; d += 10.0) {
            this.g2.draw(new Line2D.Double(d, 0.0, d, this.sizeY));
        }
        for (d = 0.0; d <= (double)this.sizeY; d += 10.0) {
            this.g2.draw(new Line2D.Double(0.0, d, this.sizeX, d));
        }
    }

    public void moveTo(double d, double d2) {
        this.cursorX = (d - this.minX) * (double)this.sizeX / this.rangeX;
        this.cursorY = (d2 - this.minY) * (double)this.sizeY / this.rangeY;
    }

    public void lineTo(double d, double d2) {
        double d3 = (d - this.minX) * (double)this.sizeX / this.rangeX;
        double d4 = (d2 - this.minY) * (double)this.sizeY / this.rangeY;
        this.g2.draw(new Line2D.Double(this.cursorX, this.cursorY, d3, d4));
        this.cursorX = d3;
        this.cursorY = d4;
    }

    public void drawPoint() {
        this.g2.draw(new Rectangle2D.Double(this.cursorX - 3.0, this.cursorY - 3.0, 6.0, 6.0));
    }

    public void setColor(Color color) {
        this.g2.setColor(color);
    }

    public void drawText(String string) {
        this.g2.drawString(string, (float)this.cursorX, (float)this.cursorY);
    }

    public static void main(String[] stringArray) {
        Plotter plotter = new Plotter();
    }

    public void plot() {
        double d;
        double d2;
        double d3;
        this.setScale(-2.0, 9.0, -7.0, 6.0);
        this.drawGrid();
        this.setColor(Color.black);
        this.drawAxis();
        this.setColor(Color.red);
        this.moveTo(0.0, 0.0);
        for (d3 = 0.0; d3 <= Math.PI * 2; d3 += 0.1) {
            d2 = Math.sin(2.0 * d3);
            d = Math.cos(d3) + 0.3;
            double d4 = Math.sin(1.2 * d3) + 2.0;
            double d5 = Math.cos(d3) + 2.0;
            this.moveTo(d2, d);
            this.lineTo(d4, d5);
        }
        this.setColor(Color.black);
        this.moveTo(3.0, 1.5);
        this.drawText("Graf funkcie y=sin(x)");
        this.setScale(-50.0, 50.0, -20.0, 80.0);
        this.moveTo(0.0, 0.0);
        this.setColor(Color.black);
        for (d3 = 0.0; d3 < 20.0; d3 += 0.2) {
            d2 = d3 * Math.sin(d3);
            d = d3 * Math.cos(d3);
            this.moveTo(d2, d);
            this.drawPoint();
        }
    }
}

