import java.awt.*;
import java.awt.event.*;
import java.awt.geom.*;
import javax.swing.*;


public class GrafickySimulator extends Plotter implements Runnable{
	public static Gula d02 = new Gula(0, 0, 0, 0, 0, 0);
        public static Gula d2 = new Gula(0, 0, 0, 0, 0, 0);
	public static Gula moon0 = new Gula(0, 0, 0, 0, 0, 0);
	public static Gula moon = new Gula(0, 0, 0, 0, 0, 0);
	public static Gula zem0 = new Gula(0, 0, 0, 0, 0, 0);
	public static Gula zem = new Gula(0, 0, 0, 0, 0, 0);
	
  	public double tmax = 0;
	public long counter=0;
	boolean run=false;
	public double step=0.01;
	private boolean isShown=true;
	/**
     * Konstruktor triedy. 
     * @param name meno okna 
     */
    GrafickySimulator(){	
        super();                    // parameter odovzdavany konstruktoru supertriedy
	setScale(-3,3,-3,3);            // skalovanie grafu
	reset();
    }

    public void reset(){
  	zem.m=9; moon.m=1;d2.m=0.0001;
	zem.r=0.3;moon.r=0.15;d2.r=0.03;
	moon.x=2;zem.x=-moon.x*moon.m/zem.m;d2.x=zem.x+0.45;
	zem.y=0;moon.y=0;d2.y=0;
	zem.vx=0;moon.vx=0;d2.vx=0;
	zem.vy=-Math.sqrt(-zem.x*moon.m)/(moon.x-zem.x); 
	moon.vy=-zem.m/moon.m*zem.vy;
	d2.vy=Math.sqrt(zem.m/(d2.x-zem.x))+zem.vy;
	    
	zem0.m=zem.m;zem0.r=zem.r;zem0.x=zem.x;zem0.y=zem.y;zem0.vx=zem.vx;zem0.vy=zem.vy;
	moon0.m=moon.m;moon0.r=moon.r;moon0.x=moon.x;moon0.y=moon.y;moon0.vx=moon.vx;moon0.vy=moon.vy;
	d02.m=d2.m;d02.r=d2.r;d02.x=d2.x;d02.y=d2.y;d02.vx=d2.vx;d02.vy=d2.vy;
    }
	    
    public void drawBall(Gula g){
	        g2.fill(new Ellipse2D.Double(cursorX-g.r/rangeX*sizeX,
	                                      cursorY+g.r/rangeY*sizeY,
                                              2*g.r/rangeX*sizeX,
                                              -2*g.r/rangeY*sizeY));	    
    }
    public void drawCircle(Gula g){
	        g2.draw(new Ellipse2D.Double(cursorX-g.r/rangeX*sizeX,
	                                      cursorY+g.r/rangeY*sizeY,
                                              2*g.r/rangeX*sizeX,
                                              -2*g.r/rangeY*sizeY));	    
    }
	public void clearBall(Gula g){
	        setColor(Color.white);
	        g2.fill(new Ellipse2D.Double(cursorX-g.r/rangeX*sizeX,
	                                      cursorY+g.r/rangeY*sizeY,
                                              2*g.r/rangeX*sizeX,
                                              -2*g.r/rangeY*sizeY));	    
    }    
 
    void clear(){ // premazanie pozadia
	 setColor(Color.white);
	 g2.fill(new Rectangle2D.Double(0,0,sizeX,sizeY));
    }
    
    public void update(Graphics g) // vyradenie neustaleho prekreslovania pozadia
    {
	paint(g);
    }    
      /*Vo funkcii plot sa vykresluje poloha objektov
     */
    public void plot(){
	    
        	if(counter%100==0) { // obcas vybielit pozadie pred prekreslenim
			clear();
		}
	        counter++;
	    
		moveTo(zem0.x,zem0.y);
//			clearBall(zem);   //Zem maze pozadie. Hybe sa pomaly a staci to a neblika
		setColor(Color.white);
		drawCircle(zem);
		moveTo(zem.x,zem.y);
		setColor(Color.blue);
		drawCircle(zem);
		
		moveTo(moon0.x,moon0.y);
		setColor(Color.white);
		drawCircle(moon);
		moveTo(moon.x,moon.y);
		setColor(Color.blue);
		drawCircle(moon);
		
		moveTo(d02.x,d02.y);
		clearBall(d2);
		setColor(Color.red);
		moveTo(d2.x,d2.y);
		drawBall(d2);
	isShown=true;	
		
  }    
     /*Vo funkcii run bezi simulacia
     */
    public void run(){
		    
 		Prostredie p=new Prostredie(1); //cislo 1 vedie na rozumne zrychlenia v modeli, nemenit
		
		double time = 0.0;		// priebezny cas simulacie
		double t=0;
		while(true){
			while(run==false){}
			isShown=false;
			repaint();
			try {
				Thread.sleep(10);
			} catch (InterruptedException e) {
				//nichts
			}
			while(isShown==false){}
			d02.x=d2.x;
			d02.y=d2.y;
 			p.posunObjekt(d2,zem,moon,step);	// posuvanie objektov// v prostredi
			
			zem0.x=zem.x;
			zem0.y=zem.y;
			p.posunObjekt(zem,d2,moon,step);	// posuvanie objektov// v prostredi
			
			moon0.x=moon.x;
			moon0.y=moon.y;
			p.posunObjekt(moon,d2,zem,step);	// posuvanie objektov// v prostredi
			
			t = t + step;		// posun na dalsi krok simulacie
		}
    } 
    
}
