/** Trieda Gula deklaruje vlastnosti hmotneho objektu v 2D priestore.
  * Atributmi triedy su poloha, rozmery a okamzita rychlost.
  */
public class Gula{
	/** 
		x suradnica polohy
	 */
	public double x;
		
	/**
		y suradnica polohy
	 */
	public double y;
		
	/**
		polomer gule
	 */
	public double r;
		
	/**
		hmotnost gule
	 */
	public double m;
		
	/**
		x zlozka rychlosti
	 */
	public double vx;
		
	/**
		y zlozka rychlosti
	 */
	public double vy;
	
	/**
		Inicializacia pociatocnych parametrov s udanim polohy, rozmerov, 
		hmotnosti a rychlosti.
	 */
	public Gula(double x, double y, double r, double m, double vx, double vy){
		this.x  = x;
		this.y  = y;
		this.r  = r;
		this.m  = m;
		this.vx = vx;
		this.vy = vy;
	}	

	/**
		Inicializacia pociatocnych parametrov s udanim polohy, rozmerov a hmotnosti.
		Zlozky rychlosti v smere x a y su nulove.
	 */
	public Gula(double x, double y, double r, double m){
		this.x  = x;
		this.y  = y;
		this.r  = r;
		this.m  = m;
		this.vx = 0.0;
		this.vy = 0.0;
	}

	/**
		Tlac aktualnej polohy objektu
	 */	
	public void tlacPolohu(){
		System.out.println("x = "+x+"\ty = "+y);
	}
	
	/**
		Kontrola kolizie objektu s inym objektom
	 */	
	public boolean kolizia(Gula w){
		double dxs = Math.abs(x-w.x);
		double dys = Math.abs(y-w.y);
		double dk = Math.sqrt(dxs*dxs+dys*dys);
		double temp;
                if(dk<=(r+w.r)){ 
 //                      System.out.println("Bummm Baaac!!!"); 
// nasleduju masivne vzorce pre necentralnu zrazku dokonale pruznych gul
// zakon zachovania hybnosti (taziskova sustava), energie a momentu hybnosti			
		double m1=m;
		double m2=w.m;
		double x1=x;
		double y1=y;
		double x2=w.x;
		double y2=w.y;
		double v1x=vx;
		double v1y=vy;
		double v2x=w.vx;
		double v2y=w.vy;
		double xt=(m1*x1+m2*x2)/(m1+m2);
		double yt=(m1*y1+m2*y2)/(m1+m2);
		double x1t=x1-xt;
		double y1t=y1-yt;
		double x2t=x2-xt;
		double y2t=y2-yt;
		double vtx=(m1*v1x+m2*v2x)/(m1+m2);
		double vty=(m1*v1y+m2*v2y)/(m1+m2);
		double v1tx=v1x-vtx;
		double v1ty=v1y-vty;
		double v2tx=v2x-vtx;
		double v2ty=v2y-vty;
		double v1t=Math.sqrt(v1tx*v1tx+v1ty*v1ty);
		double v2t=Math.sqrt(v2tx*v2tx+v2ty*v2ty);
		double wk=(m1*v1t*v1t+m2*v2t*v2t)/2;
		double v1it=Math.sqrt(2*wk/(m1*(1+m1/m2)));
		double v2it=Math.sqrt(2*wk/(m2*(1+m2/m1)));
		double dxt=x1t-x2t;
		double dyt=y1t-y2t;
		double lz=m1*v1tx*y1t-m1*v1ty*x1t+m2*v2tx*y2t-m2*v2ty*x2t;
		double l1=lz/m1;
		double l2=lz/m2;
		double v1itx=(l1*dyt+dxt*Math.sqrt((v1t*v1t*(dxt*dxt+dyt*dyt)-l1*l1)))/(dxt*dxt+dyt*dyt);
		double v1ity=-(l1*dxt-dyt*Math.sqrt((v1t*v1t*(dxt*dxt+dyt*dyt)-l1*l1)))/(dxt*dxt+dyt*dyt);
		double v2itx=-(l2*dyt+dxt*Math.sqrt((v2t*v2t*(dxt*dxt+dyt*dyt)-l2*l2)))/(dxt*dxt+dyt*dyt);
		double v2ity=(l2*dxt-dyt*Math.sqrt((v2t*v2t*(dxt*dxt+dyt*dyt)-l2*l2)))/(dxt*dxt+dyt*dyt);
		double v1ix=v1itx+vtx;
		double v1iy=v1ity+vty;
		double v2ix=v2itx+vtx;
		double v2iy=v2ity+vty;
		vx=v1ix;
		vy=v1iy;
		w.vx=v2ix;
		w.vy=v2iy;
		double wk1=m1*(v1ix*v1ix+v1iy*v1iy)/2;
		double wk2=m2*(v2ix*v2ix+v2iy*v2iy)/2;
//		System.out.println(wk1 + "   " + wk2 + "   " + (wk1+wk2));

		return true;
		}
	
		return false;
	}
}
	
	