/** Trieda Prostredie deklaruje vlastnosti prostredia, v ktorom sa pohybuju
  * objekty. V triede mozu byt implementovane vsetky zakonitosti, ktore 
  * ovplyvnuju pohyb predmetov v prostredi
  */
public class Prostredie{

	/**
		Koeficient gravitacnej sily */
	public double k;

	/**
		Inicializacia prostredia
	 */
	public Prostredie(double k){
		this.k=k;
	}	
	
	/**
		Posun objektu v prostredi
	 */	
	public void posunObjekt(Gula g1, Gula g2, Gula g3, double dt){
		g1.x = g1.x + g1.vx*dt;
		g1.y = g1.y + g1.vy*dt;
		
		double r212=(g1.x-g2.x)*(g1.x-g2.x)+(g1.y-g2.y)*(g1.y-g2.y);
		double r12=Math.sqrt(r212);
		double r213=(g1.x-g3.x)*(g1.x-g3.x)+(g1.y-g3.y)*(g1.y-g3.y);
		double r13=Math.sqrt(r213);
		
		double a12x=k*(g1.m*g2.m)/r212*((g1.x-g2.x)/r12)/g1.m;
		double a12y=k*(g1.m*g2.m)/r212*((g1.y-g2.y)/r12)/g1.m;
		double a13x=k*(g1.m*g3.m)/r213*((g1.x-g3.x)/r13)/g1.m;
		double a13y=k*(g1.m*g3.m)/r213*((g1.y-g3.y)/r13)/g1.m;

		g1.vx = g1.vx - (a12x+a13x)*dt;
		g1.vy = g1.vy - (a12y+a13y)*dt;
	}
}
