/*
 * Decompiled with CFR 0.152.
 */
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.LineUnavailableException;
import javax.sound.sampled.SourceDataLine;

public class Sound {
    static AudioFormat af;
    static SourceDataLine sdl;
    static int msecs;
    static int hz;
    static double vol;
    static byte[] buf;
    public static float SAMPLE_RATE;

    public static void initialize(int n, int n2, double d) throws LineUnavailableException {
        af = new AudioFormat(SAMPLE_RATE, 8, 1, true, false);
        sdl = AudioSystem.getSourceDataLine(af);
        msecs = n2;
        hz = n;
        vol = d;
        for (int i = 0; i < msecs * 8; ++i) {
            double d2 = (double)((float)i / (SAMPLE_RATE / (float)hz)) * 2.0 * Math.PI;
            Sound.buf[i] = (byte)(Math.sin(d2) * 127.0 * vol);
        }
        sdl.open(af);
    }

    public static void close() throws LineUnavailableException {
        sdl.close();
    }

    public static void tone() throws LineUnavailableException {
        Sound.tone(hz, msecs, vol);
    }

    public static void tone(int n, int n2, double d) throws LineUnavailableException {
        sdl.start();
        sdl.write(buf, 0, n2 * 8);
        sdl.drain();
        sdl.stop();
    }

    static {
        buf = new byte[8000];
        SAMPLE_RATE = 8000.0f;
    }
}

