import './bootstrap.js';
/*
 * Welcome to your app's main JavaScript file!
 *
 * We recommend including the built version of this JavaScript file
 * (and its CSS file) in your base layout (base.html.twig).
 */

import './styles/easyadmin.scss';
import './js/webpush-client'

addEventListener('load', async () => {
    if (!('serviceWorker' in navigator)) {
        // Service Worker isn't supported on this browser, disable or hide UI.
        console.warn('Service Worker isn\'t supported on this browser, disable or hide UI')
        return;
    }
    let sw = await navigator.serviceWorker.register('/sw.js')
})

document.addEventListener('DOMContentLoaded', async function () {
    const button = document.getElementById('subscribe-button');
    const divWebPush = document.querySelector('.js-web-push');
    if (divWebPush != null && button != null) {
        let publicKey = divWebPush.dataset.publickey;
        let subscribeUrl = divWebPush.dataset.subscribeurl;
        button.addEventListener('click', function () {
            WebPushClientFactory.create({
                serviceWorkerPath: '/sw.js', // Public path to the service worker
                serverKey: publicKey, // public key
                subscribeUrl: subscribeUrl, // application URL to store push subscriptions
            })
                .then(WebPushClient => {
                    if (WebPushClient.getSubscription() != null){
                        WebPushClient.unsubscribe();
                        window.alert(divWebPush.dataset.unsubscribesuccessful)
                    }
                    else if (WebPushClient.getPermissionState() === 'granted') {
                        WebPushClient.subscribe();
                        window.alert(divWebPush.dataset.subscribesuccessful)
                    }
                })
            ;
        });
    }
})

