document.addEventListener('DOMContentLoaded', function() {
    const divStudentIds = document.querySelector('.js-student-ids');
    if (divStudentIds == null) {
        return;
    }
    const studentIds = JSON.parse(divStudentIds.dataset.ids);
    const actions = [divStudentIds.dataset.present, divStudentIds.dataset.absent];

    studentIds.forEach(function(studentId) {
        actions.forEach(function(action) {
            const button = document.getElementById(action + '-' + studentId);
            if (button != null) {
                button.addEventListener('click', function() {
                    updateDatabaseAndTwigVariable(studentId, action, divStudentIds);
                });
            }

        });
    });
});
function pad(number) {
    if ( number < 10 ) {
        return '0' + number;
    }
    return number;
}
function updateDatabaseAndTwigVariable(studentId, action, divStudentIds) {
    fetch(divStudentIds.dataset.path, {
            method: 'POST',
            body: JSON.stringify({
                'studentId': studentId,
                'action': action
            })
        }
    )
        .catch(error => {
            console.error('Error:', error);
        })
        .then(data => {
            async function fetchData() {
                const jsonData = await data.json();
                const attendanceTime = new Date(jsonData.attendanceTime.date);
                let withoutTime1 = new Date(attendanceTime.getTime());
                withoutTime1.setUTCHours(0, 0, 0, 0);
                var formattedDate = pad(attendanceTime.getFullYear()) + '-' + pad(attendanceTime.getMonth()+1) + '-' + pad(attendanceTime.getDate());
                const tableTr = document.getElementById(studentId + '-' + formattedDate);
                if (jsonData.checked) {
                    const eveningCheckTd = tableTr.querySelector('.attendance-checked');
                    eveningCheckTd.innerHTML = pad(attendanceTime.getHours()) + ':' + pad(attendanceTime.getMinutes()) + ':' + pad(attendanceTime.getSeconds());
                }
                const currentAttendanceDiv = tableTr.querySelector('.last-action .current-attendance');
                const attendanceTd = tableTr.querySelector('.last-action');
                attendanceTd.classList.remove('bg-danger-subtle', 'bg-success-subtle');

                formattedDate = pad(attendanceTime.getDate()) + '.' + pad(attendanceTime.getMonth()+1) + '. ' + pad(attendanceTime.getHours()) + ':' + pad(attendanceTime.getMinutes());
                let newContent = '<i class="fs-4 fa-solid fa-circle-info" data-bs-toggle="tooltip" data-bs-title="' + formattedDate + '"></i>';
                if (action === divStudentIds.dataset.absent) {
                    newContent += ' Neprítomný';
                    attendanceTd.classList.add('bg-danger-subtle');
                } else if (action === divStudentIds.dataset.present) {
                    newContent += ' Prítomný';
                    attendanceTd.classList.add('bg-success-subtle');
                }

                currentAttendanceDiv.innerHTML = newContent;
                var tooltipTriggerList = [].slice.call(document.querySelectorAll('[data-bs-toggle="tooltip"]'))
                tooltipTriggerList.map(function (tooltipTriggerEl) {
                    return new bootstrap.Tooltip(tooltipTriggerEl)
                });
            }
            fetchData();
        })
    ;
}