document.addEventListener('DOMContentLoaded', function () {
    const form = document.getElementById('create_message_form');
    const form_radio_receiverType = document.getElementById('create_message_receiverType');
    const form_select_receivers = document.getElementById('create_message_receivers');

    form_radio_receiverType.addEventListener('change', (e) => changeOptions(e, form , form_select_receivers));
});

const updateForm = async (data, url) => {
    const req = await fetch(url, {
        method: 'POST',
        body: data,
        headers: {
            'Content-Type': 'application/x-www-form-urlencoded',
            'charset': 'utf-8'
        }
    });
    return await JSON.parse(await req.text());
};

const changeOptions = async (e, form, form_select_receivers) => {
    let parent = form_select_receivers.parentElement;
    parent.classList.add('d-none');
    const updateFormResponse = await updateForm(e.target.value, form.getAttribute('data-recipient-path'));
    let users = JSON.parse(updateFormResponse);
    let options = '';
    users.forEach(function (user){
        options += '<option value="' + user.id + '">' + user.firstName + ' ' + user.lastName + ' ' + user.email + '</option>';
    })
    form_select_receivers.innerHTML = options;
    parent.classList.remove('d-none');
};