document.addEventListener('DOMContentLoaded', function() {
    const divCardIds = document.querySelector('.js-card-ids');
    if (divCardIds == null) {
        return;
    }
    const cardIds = JSON.parse(divCardIds.dataset.ids);
    const action = divCardIds.dataset.remove
    cardIds.forEach(function(cardId) {
        const button = document.getElementById(action + '-' + cardId);
        if (button != null) {
            button.addEventListener('click', function() {
                updateDatabaseAndTwigVariable(cardId, divCardIds);
            });
        }
    })
})
function updateDatabaseAndTwigVariable(cardId, divCardIds) {
    fetch(divCardIds.dataset.pathremove, {
            method: 'POST',
            body: JSON.stringify({
                'cardId': cardId,
            })
        }
    )
        .catch(error => {
            console.error('Error:', error);
        })
        .then(data => {
            async function fetchData() {
                const jsonData = await data.json();
                const removed = jsonData.removed;
                if (removed === true) {
                    document.getElementById("card-" + cardId).remove();
                }
            }
            fetchData();
        })
    ;
}
