function showDeleteModal() {
    const myModalElement = document.getElementById('myModal')
    const myModal = new bootstrap.Modal(myModalElement)
    const deleteButton = document.getElementById('buttonDeleteAll');

    const modalDeleteButton = document.getElementById('modalDeleteButton');

    deleteButton.addEventListener('click', function (e) {
        e.preventDefault()
        myModal.show()
    })
    modalDeleteButton.addEventListener("click", function (){
        window.location.href = deleteButton.href;
    })
}

function editAndDeleteActionOnSchedules() {
    const divScheduleIds = document.querySelector('.js-schedule-ids');
    if (divScheduleIds == null) {
        return;
    }
    const scheduleIds = JSON.parse(divScheduleIds.dataset.ids);
    const actions = [divScheduleIds.dataset.delete, divScheduleIds.dataset.modify];
    scheduleIds.forEach(function(scheduleId) {
        actions.forEach(function(action) {
            const button = document.getElementById(action + '-' + scheduleId);
            if (button != null) {
                button.addEventListener('click', function() {
                    if (action === divScheduleIds.dataset.delete) {
                        const pathDelete = divScheduleIds.dataset.pathdelete;
                        window.location.href = pathDelete.replace('__id__', scheduleId);
                    }
                    else {
                        const pathModify = divScheduleIds.dataset.pathmodify;
                        window.location.href = pathModify.replace('__id__', scheduleId);
                    }
                });
            }

        });
    });
}

document.addEventListener('DOMContentLoaded', function() {
    showDeleteModal()
    editAndDeleteActionOnSchedules()
});