document.addEventListener('DOMContentLoaded', function () {
    const divMessageUrl = document.querySelector('.js-message-url');
    if (divMessageUrl == null) {
        return;
    }
    const searchForm = document.getElementById('search-form');

    searchForm.addEventListener('submit', function (event) {
        event.preventDefault(); // Prevent default form submission
        const query = searchForm.querySelector('input[name="query"]').value;
        const url = divMessageUrl.dataset.path;
        if (!query){
            window.location.href = url
        }
        else {
            window.location.href = url + "&query=" + encodeURIComponent(query);
        }
    });
});