<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20231202180112 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE TABLE attendance (id INT AUTO_INCREMENT NOT NULL, student_id INT NOT NULL, time DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', valid_until DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', action SMALLINT NOT NULL, INDEX IDX_6DE30D91CB944F1A (student_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE classroom (id INT AUTO_INCREMENT NOT NULL, school_id INT DEFAULT NULL, name VARCHAR(255) DEFAULT NULL, INDEX IDX_497D309DC32A47EE (school_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE coach (id INT AUTO_INCREMENT NOT NULL, first_name VARCHAR(255) NOT NULL, last_name VARCHAR(255) NOT NULL, phone_number VARCHAR(16) NOT NULL, phone_country VARCHAR(2) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE coach_student (coach_id INT NOT NULL, student_id INT NOT NULL, INDEX IDX_CF3477B3C105691 (coach_id), INDEX IDX_CF3477BCB944F1A (student_id), PRIMARY KEY(coach_id, student_id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE educator (id INT AUTO_INCREMENT NOT NULL, user_id INT NOT NULL, UNIQUE INDEX UNIQ_8BA1BF3DA76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE father (id INT AUTO_INCREMENT NOT NULL, user_id INT NOT NULL, UNIQUE INDEX UNIQ_CF2531B8A76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE meeting (id INT AUTO_INCREMENT NOT NULL, educator_id INT DEFAULT NULL, individual_student_id INT DEFAULT NULL, planned_date DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_F515E139887E9271 (educator_id), INDEX IDX_F515E1398F84F005 (individual_student_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE mother (id INT AUTO_INCREMENT NOT NULL, user_id INT NOT NULL, UNIQUE INDEX UNIQ_1AD27F1AA76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE room (id INT AUTO_INCREMENT NOT NULL, door_number SMALLINT NOT NULL, floor SMALLINT NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE school (id INT AUTO_INCREMENT NOT NULL, name VARCHAR(255) DEFAULT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE student (id INT AUTO_INCREMENT NOT NULL, educator_id INT DEFAULT NULL, mother_id INT DEFAULT NULL, father_id INT DEFAULT NULL, room_id INT DEFAULT NULL, user_id INT NOT NULL, classroom_id INT DEFAULT NULL, street VARCHAR(255) DEFAULT NULL, postal_code VARCHAR(255) DEFAULT NULL, city VARCHAR(255) DEFAULT NULL, country VARCHAR(2) DEFAULT NULL, INDEX IDX_B723AF33887E9271 (educator_id), INDEX IDX_B723AF33B78A354D (mother_id), INDEX IDX_B723AF332055B9A2 (father_id), INDEX IDX_B723AF3354177093 (room_id), UNIQUE INDEX UNIQ_B723AF33A76ED395 (user_id), INDEX IDX_B723AF336278D5A8 (classroom_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE user (id INT AUTO_INCREMENT NOT NULL, email VARCHAR(64) NOT NULL, password VARCHAR(255) NOT NULL, role LONGTEXT NOT NULL, active TINYINT(1) NOT NULL, first_name VARCHAR(255) NOT NULL, last_name VARCHAR(255) NOT NULL, phone_country VARCHAR(2) NOT NULL, phone_number VARCHAR(16) NOT NULL, PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE messenger_messages (id BIGINT AUTO_INCREMENT NOT NULL, body LONGTEXT NOT NULL, headers LONGTEXT NOT NULL, queue_name VARCHAR(190) NOT NULL, created_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', available_at DATETIME NOT NULL COMMENT \'(DC2Type:datetime_immutable)\', delivered_at DATETIME DEFAULT NULL COMMENT \'(DC2Type:datetime_immutable)\', INDEX IDX_75EA56E0FB7336F0 (queue_name), INDEX IDX_75EA56E0E3BD61CE (available_at), INDEX IDX_75EA56E016BA31DB (delivered_at), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE attendance ADD CONSTRAINT FK_6DE30D91CB944F1A FOREIGN KEY (student_id) REFERENCES student (id)');
        $this->addSql('ALTER TABLE classroom ADD CONSTRAINT FK_497D309DC32A47EE FOREIGN KEY (school_id) REFERENCES school (id)');
        $this->addSql('ALTER TABLE coach_student ADD CONSTRAINT FK_CF3477B3C105691 FOREIGN KEY (coach_id) REFERENCES coach (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE coach_student ADD CONSTRAINT FK_CF3477BCB944F1A FOREIGN KEY (student_id) REFERENCES student (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE educator ADD CONSTRAINT FK_8BA1BF3DA76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE father ADD CONSTRAINT FK_CF2531B8A76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE meeting ADD CONSTRAINT FK_F515E139887E9271 FOREIGN KEY (educator_id) REFERENCES educator (id)');
        $this->addSql('ALTER TABLE meeting ADD CONSTRAINT FK_F515E1398F84F005 FOREIGN KEY (individual_student_id) REFERENCES student (id)');
        $this->addSql('ALTER TABLE mother ADD CONSTRAINT FK_1AD27F1AA76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE student ADD CONSTRAINT FK_B723AF33887E9271 FOREIGN KEY (educator_id) REFERENCES educator (id)');
        $this->addSql('ALTER TABLE student ADD CONSTRAINT FK_B723AF33B78A354D FOREIGN KEY (mother_id) REFERENCES mother (id)');
        $this->addSql('ALTER TABLE student ADD CONSTRAINT FK_B723AF332055B9A2 FOREIGN KEY (father_id) REFERENCES father (id)');
        $this->addSql('ALTER TABLE student ADD CONSTRAINT FK_B723AF3354177093 FOREIGN KEY (room_id) REFERENCES room (id)');
        $this->addSql('ALTER TABLE student ADD CONSTRAINT FK_B723AF33A76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE student ADD CONSTRAINT FK_B723AF336278D5A8 FOREIGN KEY (classroom_id) REFERENCES classroom (id)');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('ALTER TABLE attendance DROP FOREIGN KEY FK_6DE30D91CB944F1A');
        $this->addSql('ALTER TABLE classroom DROP FOREIGN KEY FK_497D309DC32A47EE');
        $this->addSql('ALTER TABLE coach_student DROP FOREIGN KEY FK_CF3477B3C105691');
        $this->addSql('ALTER TABLE coach_student DROP FOREIGN KEY FK_CF3477BCB944F1A');
        $this->addSql('ALTER TABLE educator DROP FOREIGN KEY FK_8BA1BF3DA76ED395');
        $this->addSql('ALTER TABLE father DROP FOREIGN KEY FK_CF2531B8A76ED395');
        $this->addSql('ALTER TABLE meeting DROP FOREIGN KEY FK_F515E139887E9271');
        $this->addSql('ALTER TABLE meeting DROP FOREIGN KEY FK_F515E1398F84F005');
        $this->addSql('ALTER TABLE mother DROP FOREIGN KEY FK_1AD27F1AA76ED395');
        $this->addSql('ALTER TABLE student DROP FOREIGN KEY FK_B723AF33887E9271');
        $this->addSql('ALTER TABLE student DROP FOREIGN KEY FK_B723AF33B78A354D');
        $this->addSql('ALTER TABLE student DROP FOREIGN KEY FK_B723AF332055B9A2');
        $this->addSql('ALTER TABLE student DROP FOREIGN KEY FK_B723AF3354177093');
        $this->addSql('ALTER TABLE student DROP FOREIGN KEY FK_B723AF33A76ED395');
        $this->addSql('ALTER TABLE student DROP FOREIGN KEY FK_B723AF336278D5A8');
        $this->addSql('DROP TABLE attendance');
        $this->addSql('DROP TABLE classroom');
        $this->addSql('DROP TABLE coach');
        $this->addSql('DROP TABLE coach_student');
        $this->addSql('DROP TABLE educator');
        $this->addSql('DROP TABLE father');
        $this->addSql('DROP TABLE meeting');
        $this->addSql('DROP TABLE mother');
        $this->addSql('DROP TABLE room');
        $this->addSql('DROP TABLE school');
        $this->addSql('DROP TABLE student');
        $this->addSql('DROP TABLE user');
        $this->addSql('DROP TABLE messenger_messages');
    }
}
