<?php

declare(strict_types=1);

namespace DoctrineMigrations;

use Doctrine\DBAL\Schema\Schema;
use Doctrine\Migrations\AbstractMigration;

/**
 * Auto-generated Migration: Please modify to your needs!
 */
final class Version20240301163651 extends AbstractMigration
{
    public function getDescription(): string
    {
        return '';
    }

    public function up(Schema $schema): void
    {
        // this up() migration is auto-generated, please modify it to your needs
        $this->addSql('ALTER TABLE student DROP FOREIGN KEY FK_B723AF332055B9A2');
        $this->addSql('ALTER TABLE student DROP FOREIGN KEY FK_B723AF33B78A354D');
        $this->addSql('CREATE TABLE guardian (id INT AUTO_INCREMENT NOT NULL, user_id INT NOT NULL, INDEX IDX_64486055A76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('CREATE TABLE guardian_student (guardian_id INT NOT NULL, student_id INT NOT NULL, INDEX IDX_DAA2A68511CC8B0A (guardian_id), INDEX IDX_DAA2A685CB944F1A (student_id), PRIMARY KEY(guardian_id, student_id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB');
        $this->addSql('ALTER TABLE guardian ADD CONSTRAINT FK_64486055A76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE guardian_student ADD CONSTRAINT FK_DAA2A68511CC8B0A FOREIGN KEY (guardian_id) REFERENCES guardian (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE guardian_student ADD CONSTRAINT FK_DAA2A685CB944F1A FOREIGN KEY (student_id) REFERENCES student (id) ON DELETE CASCADE');
        $this->addSql('ALTER TABLE father DROP FOREIGN KEY FK_CF2531B8A76ED395');
        $this->addSql('ALTER TABLE mother DROP FOREIGN KEY FK_1AD27F1AA76ED395');
        $this->addSql('DROP TABLE father');
        $this->addSql('DROP TABLE mother');
        $this->addSql('ALTER TABLE coach ADD user_id INT NOT NULL, DROP first_name, DROP last_name, DROP phone_number, DROP phone_country');
        $this->addSql('ALTER TABLE coach ADD CONSTRAINT FK_3F596DCCA76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('CREATE INDEX IDX_3F596DCCA76ED395 ON coach (user_id)');
        $this->addSql('ALTER TABLE educator DROP INDEX UNIQ_8BA1BF3DA76ED395, ADD INDEX IDX_8BA1BF3DA76ED395 (user_id)');
        $this->addSql('ALTER TABLE master_teacher ADD user_id INT NOT NULL, DROP first_name, DROP last_name, DROP phone_number, DROP phone_country');
        $this->addSql('ALTER TABLE master_teacher ADD CONSTRAINT FK_6CD14BBDA76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('CREATE INDEX IDX_6CD14BBDA76ED395 ON master_teacher (user_id)');
        $this->addSql('DROP INDEX IDX_B723AF33B78A354D ON student');
        $this->addSql('DROP INDEX IDX_B723AF332055B9A2 ON student');
        $this->addSql('ALTER TABLE student DROP mother_id, DROP father_id');
    }

    public function down(Schema $schema): void
    {
        // this down() migration is auto-generated, please modify it to your needs
        $this->addSql('CREATE TABLE father (id INT AUTO_INCREMENT NOT NULL, user_id INT NOT NULL, UNIQUE INDEX UNIQ_CF2531B8A76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ');
        $this->addSql('CREATE TABLE mother (id INT AUTO_INCREMENT NOT NULL, user_id INT NOT NULL, UNIQUE INDEX UNIQ_1AD27F1AA76ED395 (user_id), PRIMARY KEY(id)) DEFAULT CHARACTER SET utf8mb4 COLLATE `utf8mb4_unicode_ci` ENGINE = InnoDB COMMENT = \'\' ');
        $this->addSql('ALTER TABLE father ADD CONSTRAINT FK_CF2531B8A76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE mother ADD CONSTRAINT FK_1AD27F1AA76ED395 FOREIGN KEY (user_id) REFERENCES user (id)');
        $this->addSql('ALTER TABLE guardian DROP FOREIGN KEY FK_64486055A76ED395');
        $this->addSql('ALTER TABLE guardian_student DROP FOREIGN KEY FK_DAA2A68511CC8B0A');
        $this->addSql('ALTER TABLE guardian_student DROP FOREIGN KEY FK_DAA2A685CB944F1A');
        $this->addSql('DROP TABLE guardian');
        $this->addSql('DROP TABLE guardian_student');
        $this->addSql('ALTER TABLE student ADD mother_id INT DEFAULT NULL, ADD father_id INT DEFAULT NULL');
        $this->addSql('ALTER TABLE student ADD CONSTRAINT FK_B723AF332055B9A2 FOREIGN KEY (father_id) REFERENCES father (id)');
        $this->addSql('ALTER TABLE student ADD CONSTRAINT FK_B723AF33B78A354D FOREIGN KEY (mother_id) REFERENCES mother (id)');
        $this->addSql('CREATE INDEX IDX_B723AF33B78A354D ON student (mother_id)');
        $this->addSql('CREATE INDEX IDX_B723AF332055B9A2 ON student (father_id)');
        $this->addSql('ALTER TABLE master_teacher DROP FOREIGN KEY FK_6CD14BBDA76ED395');
        $this->addSql('DROP INDEX IDX_6CD14BBDA76ED395 ON master_teacher');
        $this->addSql('ALTER TABLE master_teacher ADD first_name VARCHAR(255) NOT NULL, ADD last_name VARCHAR(255) NOT NULL, ADD phone_number VARCHAR(16) DEFAULT NULL, ADD phone_country VARCHAR(2) DEFAULT NULL, DROP user_id');
        $this->addSql('ALTER TABLE coach DROP FOREIGN KEY FK_3F596DCCA76ED395');
        $this->addSql('DROP INDEX IDX_3F596DCCA76ED395 ON coach');
        $this->addSql('ALTER TABLE coach ADD first_name VARCHAR(255) NOT NULL, ADD last_name VARCHAR(255) NOT NULL, ADD phone_number VARCHAR(16) DEFAULT NULL, ADD phone_country VARCHAR(2) DEFAULT NULL, DROP user_id');
        $this->addSql('ALTER TABLE educator DROP INDEX IDX_8BA1BF3DA76ED395, ADD UNIQUE INDEX UNIQ_8BA1BF3DA76ED395 (user_id)');
    }
}
