<?php

namespace App\Command;

use App\Entity\MessageReceiver;
use App\Repository\MessageReceiverRepository;
use App\Services\NotificationService;
use App\Services\PushNotifier;
use App\Services\UserSubscriptionManager;
use Doctrine\ORM\EntityManagerInterface;
use EasyCorp\Bundle\EasyAdminBundle\Router\AdminUrlGenerator;
use Exception;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Contracts\Translation\TranslatorInterface;

#[AsCommand(
    name: 'app:notify-send-message',
    description: 'Creating notification for unsent messages',
)]
class NotificationForUnsentMessagesCommand extends Command
{
    private PushNotifier $pushNotifier;
    private EntityManagerInterface $entityManager;
    private UserSubscriptionManager $userSubscriptionManager;
    private MessageReceiverRepository $messageReceiverRepository;
    private AdminUrlGenerator $adminUrlGenerator;
    private TranslatorInterface $translator;

    public function __construct(PushNotifier $pushNotifier, EntityManagerInterface $entityManager, UserSubscriptionManager $userSubscriptionManager,
                                MessageReceiverRepository $messageReceiverRepository, AdminUrlGenerator $adminUrlGenerator, TranslatorInterface $translator)
    {
        parent::__construct();
        $this->pushNotifier = $pushNotifier;
        $this->entityManager = $entityManager;
        $this->userSubscriptionManager = $userSubscriptionManager;
        $this->messageReceiverRepository = $messageReceiverRepository;
        $this->adminUrlGenerator = $adminUrlGenerator;
        $this->translator = $translator;
    }

    /**
     * @throws Exception
     */
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $io = new SymfonyStyle($input, $output);
        $io->progressStart();
        $unsentMessageReceivers = $this->messageReceiverRepository->findUnsentMessagesForReceivers();
        $io->progressAdvance();
        /** @var MessageReceiver $messageReceiver */
        foreach ($unsentMessageReceivers as $messageReceiver) {
            $io->progressAdvance();
            $notificationService = new NotificationService($this->userSubscriptionManager, $this->adminUrlGenerator, $this->pushNotifier, $this->translator);
            $notificationService->createNotificationForUnsentMessages($messageReceiver);
            $messageReceiver->setSent(true);
        }
        $io->progressAdvance();
        $this->entityManager->flush();
        $io->progressFinish();
        $io->success('Unsent messages sent.');

        return Command::SUCCESS;
    }
}
