<?php

namespace App\Command;

use App\Repository\MailNotificationRepository;
use App\Services\Mailer;
use Doctrine\ORM\NonUniqueResultException;
use ReflectionException;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;
use Symfony\Component\Mailer\Exception\TransportExceptionInterface;
use Twig\Error\LoaderError;
use Twig\Error\RuntimeError;
use Twig\Error\SyntaxError;

#[AsCommand(
    name: 'app:send-mails',
    description: 'Sending unsend mails',
)]
class SendMailsCommand extends Command
{
    private MailNotificationRepository $mailNotificationRepository;
    private Mailer $mailer;

    public function __construct(Mailer $mailer, MailNotificationRepository $mailNotificationRepository)
    {
        parent::__construct();
        $this->mailNotificationRepository = $mailNotificationRepository;
        $this->mailer = $mailer;
    }

    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $io = new SymfonyStyle($input, $output);
        $io->progressStart();

        $unsentMailNotifications = $this->mailNotificationRepository->findBy(['sent' => false]);
        $io->progressAdvance();
        foreach ($unsentMailNotifications as $unsentMailNotification) {
            try {
                $this->mailer->sendMailNotification($unsentMailNotification);
            } catch (NonUniqueResultException|ReflectionException|TransportExceptionInterface|LoaderError|RuntimeError|SyntaxError $e) {
            }
            $io->progressAdvance();
        }

        $io->progressFinish();
        $io->success('Mail notifications has been send');

        return Command::SUCCESS;
    }
}
