<?php

namespace App\Command;

use App\Repository\PushNotificationRepository;
use App\Services\PushNotifier;
use ErrorException;
use Symfony\Component\Console\Attribute\AsCommand;
use Symfony\Component\Console\Command\Command;
use Symfony\Component\Console\Input\InputInterface;
use Symfony\Component\Console\Output\OutputInterface;
use Symfony\Component\Console\Style\SymfonyStyle;

#[AsCommand(
    name: 'app:send-push-notifications',
    description: 'Sending unsend push notifications',
)]
class SendPushNotificationsCommand extends Command
{
    private PushNotifier $pushNotifier;
    private PushNotificationRepository $pushNotificationRepository;

    public function __construct(PushNotifier $pushNotifier, PushNotificationRepository $pushNotificationRepository)
    {
        parent::__construct();
        $this->pushNotifier = $pushNotifier;
        $this->pushNotificationRepository = $pushNotificationRepository;
    }

    /**
     * @throws ErrorException
     */
    protected function execute(InputInterface $input, OutputInterface $output): int
    {
        $io = new SymfonyStyle($input, $output);
        $io->progressStart();
        $unsentPushNotifications = $this->pushNotificationRepository->findBy(['sent' => false]);
        $io->progressAdvance();
        foreach ($unsentPushNotifications as $unsentPushNotification) {
            $this->pushNotifier->sendNotification($unsentPushNotification);
            $io->progressAdvance();
        }

        $io->progressFinish();
        $io->success('Push notifications has been send');

        return Command::SUCCESS;
    }
}
