<?php

namespace App\Controller\Admin\Crud;

use App\Controller\Educator\Crud\SchoolCrudEducatorController;
use App\Entity\Classroom;
use App\Entity\User;
use Doctrine\ORM\QueryBuilder;
use EasyCorp\Bundle\EasyAdminBundle\Collection\FieldCollection;
use EasyCorp\Bundle\EasyAdminBundle\Collection\FilterCollection;
use EasyCorp\Bundle\EasyAdminBundle\Config\Crud;
use EasyCorp\Bundle\EasyAdminBundle\Controller\AbstractCrudController;
use EasyCorp\Bundle\EasyAdminBundle\Dto\EntityDto;
use EasyCorp\Bundle\EasyAdminBundle\Dto\SearchDto;
use EasyCorp\Bundle\EasyAdminBundle\Field\AssociationField;
use EasyCorp\Bundle\EasyAdminBundle\Field\IdField;
use EasyCorp\Bundle\EasyAdminBundle\Field\TextField;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted(User::ROLE_ADMIN)]
class ClassroomCrudController extends AbstractCrudController
{
    public static function getEntityFqcn(): string
    {
        return Classroom::class;
    }
    public function createIndexQueryBuilder(SearchDto $searchDto, EntityDto $entityDto, FieldCollection $fields, FilterCollection $filters): QueryBuilder
    {
        return parent::createIndexQueryBuilder($searchDto, $entityDto, $fields, $filters)
            ->addSelect('school_index')
            ->leftJoin('entity.school', 'school_index');
    }
    public function configureCrud(Crud $crud): Crud
    {
        return $crud
            ->setEntityLabelInSingular('entity.classroom.singular_name')
            ->setEntityLabelInPlural('entity.classroom.plural_name')
            ->setDefaultSort(['id' => 'ASC',])
            ->setSearchFields(['school.name', 'name'])
            ->setPageTitle(Crud::PAGE_DETAIL, 'entity.classroom.singular_name')
            ;
    }

    public function configureFields(string $pageName): iterable
    {
        $controller = in_array('ROLE_ADMIN', $this->getUser()->getRoles()) ? SchoolCrudController::class : SchoolCrudEducatorController::class;

        return [
            IdField::new('id')
                ->setLabel('entity.id')
                ->hideOnForm(),
            TextField::new('name')
                ->setLabel('entity.classroom.singular_name')
                ->setColumns('col-12'),
            AssociationField::new('school')
                ->autocomplete()
                ->setCrudController($controller)
                ->setLabel('entity.school.singular_name')
                ->setColumns('col-12'),
            AssociationField::new('students')
                ->setLabel('entity.student.plural_name')
                ->hideOnIndex()
                ->setColumns('col-12')
                ->hideOnForm()
                ->setTemplatePath('admin/show_students.html.twig')
        ];
    }
}
