<?php

namespace App\Controller\Admin\Crud;

use App\Controller\Educator\Crud\StudentCrudEducatorController;
use App\Entity\MeetingAttendance;
use EasyCorp\Bundle\EasyAdminBundle\Controller\AbstractCrudController;
use EasyCorp\Bundle\EasyAdminBundle\Field\AssociationField;
use EasyCorp\Bundle\EasyAdminBundle\Field\IdField;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted(new Expression('is_granted("ROLE_ADMIN") or is_granted("ROLE_EDUCATOR")'))]
class MeetingAttendanceCrudController extends AbstractCrudController
{
    public static function getEntityFqcn(): string
    {
        return MeetingAttendance::class;
    }
    public function configureFields(string $pageName): iterable
    {
        $controller = in_array('ROLE_ADMIN', $this->getUser()->getRoles()) ? StudentCrudController::class : StudentCrudEducatorController::class;

        return [
            IdField::new('id')
                ->setLabel('entity.id')
            ->hideOnForm(),
            AssociationField::new('student')
                ->setLabel('entity.student.singular_name')
            ->autocomplete()
            ->setCrudController($controller)
            ,
        ];
    }

}
