<?php

namespace App\Controller\Admin\Crud;

use App\Entity\School;
use App\Entity\User;
use EasyCorp\Bundle\EasyAdminBundle\Config\Crud;
use EasyCorp\Bundle\EasyAdminBundle\Controller\AbstractCrudController;
use EasyCorp\Bundle\EasyAdminBundle\Field\AssociationField;
use EasyCorp\Bundle\EasyAdminBundle\Field\IdField;
use EasyCorp\Bundle\EasyAdminBundle\Field\TextField;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted(User::ROLE_ADMIN)]
class SchoolCrudController extends AbstractCrudController
{
    public static function getEntityFqcn(): string
    {
        return School::class;
    }
    public function configureCrud(Crud $crud): Crud
    {
        return $crud
            ->setEntityLabelInSingular('entity.school.singular_name')
            ->setEntityLabelInPlural('entity.school.plural_name')
            ->setDefaultSort(['id' => 'ASC',])
            ->setSearchFields(['name'])
            ;
    }


    public function configureFields(string $pageName): iterable
    {
        return [
            IdField::new('id')
                ->setLabel('entity.id')
                ->hideOnForm(),
            TextField::new('name')
                ->setLabel('entity.school.name')
                ->setColumns('col-12'),
            AssociationField::new('classrooms')
                ->setLabel('entity.classroom.plural_name')
                ->hideOnIndex()
                ->setColumns('col-12')
                ->hideOnForm()
                ->setTemplatePath('admin/show_classrooms.html.twig'),
        ];
    }

}
