<?php

namespace App\Controller\Admin\Crud;

use App\Controller\Educator\Crud\EducatorCrudEducatorController;
use App\Entity\StudentNote;
use App\Entity\User;
use DateTimeImmutable;
use Doctrine\ORM\QueryBuilder;
use EasyCorp\Bundle\EasyAdminBundle\Collection\FieldCollection;
use EasyCorp\Bundle\EasyAdminBundle\Collection\FilterCollection;
use EasyCorp\Bundle\EasyAdminBundle\Config\Crud;
use EasyCorp\Bundle\EasyAdminBundle\Config\Filters;
use EasyCorp\Bundle\EasyAdminBundle\Controller\AbstractCrudController;
use EasyCorp\Bundle\EasyAdminBundle\Dto\EntityDto;
use EasyCorp\Bundle\EasyAdminBundle\Dto\SearchDto;
use EasyCorp\Bundle\EasyAdminBundle\Field\AssociationField;
use EasyCorp\Bundle\EasyAdminBundle\Field\DateTimeField;
use EasyCorp\Bundle\EasyAdminBundle\Field\IdField;
use EasyCorp\Bundle\EasyAdminBundle\Field\TextField;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted(User::ROLE_ADMIN)]
class StudentNoteCrudController extends AbstractCrudController
{
    public static function getEntityFqcn(): string
    {
        return StudentNote::class;
    }
    public function createEntity(string $entityFqcn): StudentNote
    {
        $note = new StudentNote();
        $note->setTime(new DateTimeImmutable());
        return $note;
    }
    public function createIndexQueryBuilder(SearchDto $searchDto, EntityDto $entityDto, FieldCollection $fields, FilterCollection $filters): QueryBuilder
    {
        return parent::createIndexQueryBuilder($searchDto, $entityDto, $fields, $filters)
            ->addSelect('user_index', 'student_index')
            ->leftJoin('entity.student', 'student_index')
            ->leftJoin('student_index.user', 'user_index');
    }

    public function configureCrud(Crud $crud): Crud
    {
        return $crud
            ->setEntityLabelInSingular('entity.student_note.singular_name')
            ->setEntityLabelInPlural('entity.student_note.plural_name')
            ->setDefaultSort(['time' => 'DESC',])
            ->setSearchFields(['student.user.firstName', 'student.user.lastName', 'student.user.email', 'student.user.phoneNumber'])
            ->setPageTitle(Crud::PAGE_DETAIL, 'entity.student_note.singular_name')
            ;
    }
    public function configureFilters(Filters $filters): Filters
    {
        return $filters
            ->add('educator')
            ->add('student')
            ->add('time')
            ;
    }


    public function configureFields(string $pageName): iterable
    {
        $controller = in_array(User::ROLE_ADMIN, $this->getUser()->getRoles()) ? EducatorCrudController::class : EducatorCrudEducatorController::class;

        return [
            IdField::new('id')
                ->setLabel('entity.id')
                ->hideOnForm(),
            AssociationField::new('educator')
                ->setLabel('entity.educator.singular_name')
                ->setCrudController($controller)
                ->autocomplete()
                ->setColumns('col-12'),
            AssociationField::new('student')
                ->setLabel('entity.student.singular_name')
                ->setColumns('col-12'),
            DateTimeField::new('time')
                ->setLabel('entity.schedule.time')
                ->hideOnForm()
                ->setColumns('col-12'),
            TextField::new('note')
                ->setLabel('entity.student_note.singular_name')
                ->setColumns('col-12'),
        ];
    }

}
