<?php

namespace App\Controller\Admin\Crud;

use App\Entity\User;
use EasyCorp\Bundle\EasyAdminBundle\Controller\AbstractCrudController;
use EasyCorp\Bundle\EasyAdminBundle\Field\ChoiceField;
use EasyCorp\Bundle\EasyAdminBundle\Field\CountryField;
use EasyCorp\Bundle\EasyAdminBundle\Field\EmailField;
use EasyCorp\Bundle\EasyAdminBundle\Field\IdField;
use EasyCorp\Bundle\EasyAdminBundle\Field\TelephoneField;
use EasyCorp\Bundle\EasyAdminBundle\Field\TextField;

class UserCrudController extends AbstractCrudController
{
    public static function getEntityFqcn(): string
    {
        return User::class;
    }

    public function configureFields(string $pageName): iterable
    {
        return [
            IdField::new('id')
                ->setLabel('entity.id')
                ->hideOnForm(),
            EmailField::new('email')
                ->setLabel('entity.user.email')
                ->setColumns('col-12')
                ->setRequired(true),
            TextField::new('firstName')
                ->setLabel('entity.user.first_name')
                ->setColumns('col-6')
                ->setRequired(true),
            TextField::new('lastName')
                ->setLabel('entity.user.last_name')
                ->setColumns('col-6')
                ->setRequired(true),
            ChoiceField::new('active')
                ->setLabel('entity.user.active.name')
                ->setColumns('col-12')
                ->setRequired(true)
                ->setChoices([
                    'entity.user.active.no' => 0,
                    'entity.user.active.yes' => 1]),
            CountryField::new('phoneCountry')
                ->setLabel('Telefónna predvoľba')
                ->setLabel('entity.user.phone_country')
                ->setColumns('col-6'),
            TelephoneField::new('phoneNumber')
                ->setColumns('col-6')
                ->setLabel('entity.user.phone_number'),
        ];
    }

}
