<?php
namespace App\Controller\Admin\Filter;

use App\Form\FilterType\MeetingTypeFilterType;
use Doctrine\ORM\QueryBuilder;
use EasyCorp\Bundle\EasyAdminBundle\Contracts\Filter\FilterInterface;
use EasyCorp\Bundle\EasyAdminBundle\Dto\EntityDto;
use EasyCorp\Bundle\EasyAdminBundle\Dto\FieldDto;
use EasyCorp\Bundle\EasyAdminBundle\Dto\FilterDataDto;
use EasyCorp\Bundle\EasyAdminBundle\Filter\FilterTrait;


class MeetingTypeFilter implements FilterInterface
{
    use FilterTrait;

    public static function new(string $propertyName, $label = null): self
    {
        return (new self())
            ->setFilterFqcn(__CLASS__)
            ->setProperty($propertyName)
            ->setLabel($label)
            ->setFormTypeOption('mapped', false)
            ->setFormType(MeetingTypeFilterType::class);
    }

    public function apply(QueryBuilder $queryBuilder, FilterDataDto $filterDataDto, ?FieldDto $fieldDto, EntityDto $entityDto): void
    {
        $queryBuilder
            ->leftJoin(sprintf('%s.meetingAttendances', $filterDataDto->getEntityAlias()), 'meetingAttendance_filter');
        if ($filterDataDto->getValue() === '1') {
            // individual meeting
            $queryBuilder
                ->andWhere(sprintf('SIZE(%s.meetingAttendances) = 1', $filterDataDto->getEntityAlias()));
        }
        else {
            // group meeting
            $queryBuilder
                ->andWhere(sprintf('SIZE(%s.meetingAttendances) > 1', $filterDataDto->getEntityAlias()));
        }

    }
}