<?php

namespace App\Controller;

use App\Entity\User;
use App\Form\UpdateDormitoryCardType;
use App\Repository\DormitoryCardRepository;
use Doctrine\ORM\EntityManagerInterface;
use EasyCorp\Bundle\EasyAdminBundle\Router\AdminUrlGenerator;
use Exception;
use Knp\Component\Pager\PaginatorInterface;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\JsonResponse;
use Symfony\Component\HttpFoundation\Request;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/dormitory_card', name: 'app_dormitory_card_')]
class CardController extends AbstractController
{
    /**
     * @throws Exception
     */
    #[Route('/show', name: 'show')]
    #[IsGranted(User::ROLE_ADMIN)]
    public function show(Request $request, DormitoryCardRepository $dormitoryCardRepository, AdminUrlGenerator $adminUrlGenerator,
                         PaginatorInterface $paginator): Response
    {
        /** @var User $user */
        $user = $this->getUser();
        $q = $request->query->get('query');
        $queryBuilder = $dormitoryCardRepository->getActiveCardsWithStudentsWithSearchQueryBuilder($q);
        $pagination = $paginator->paginate(
            $queryBuilder, /* query NOT result */
            $request->query->getInt('page', 1)/*page number*/,
            10/*limit per page*/
        );
        $url = $adminUrlGenerator->setDashboard($user->getDashboard())->setRoute('app_dormitory_card_show_empty_cards')->generateUrl();
        return $this->render('dormitory_card/show.html.twig', [
            'activeCards' => $pagination,
            'buttonShowEmptyCards' => $url,
        ]);
    }
    /**
     * @throws Exception
     */
    #[Route('/show_empty_cards', name: 'show_empty_cards')]
    #[IsGranted(User::ROLE_ADMIN)]
    public function showEmptyCards(DormitoryCardRepository $dormitoryCardRepository, PaginatorInterface $paginator, Request $request,): Response
    {
        $q = $request->query->get('query');
        $queryBuilder = $dormitoryCardRepository->getCardsWithoutStudentWithSearchQueryBuilder($q);
        $pagination = $paginator->paginate(
            $queryBuilder, /* query NOT result */
            $request->query->getInt('page', 1)/*page number*/,
            10/*limit per page*/
        );
        return $this->render('dormitory_card/show_unset_cards.html.twig', [
            'activeCards' => $pagination,
        ]);
    }
    #[Route('/remove_card', name: 'remove_card', methods: ['POST'])]
    #[IsGranted(User::ROLE_ADMIN)]
    public function update(EntityManagerInterface $entityManager, DormitoryCardRepository $dormitoryCardRepository, Request $request): JsonResponse
    {
        $parameters = json_decode($request->getContent());

        $card = $dormitoryCardRepository->findOneBy(['id' => $parameters->cardId]);
        if ($card === null) {
            throw $this->createNotFoundException();
        }
        $entityManager->remove($card);
        $entityManager->flush();

        return new JsonResponse([
            'removed' => true,
        ]);
    }

    /**
     * @throws Exception
     */
    #[Route('/add_student', name: 'add_student')]
    #[IsGranted(User::ROLE_ADMIN)]
    public function addStudent(DormitoryCardRepository $dormitoryCardRepository, Request $request, EntityManagerInterface $entityManager,
                               AdminUrlGenerator $adminUrlGenerator): Response
    {
        /** @var User $user */
        $user = $this->getUser();
        $card_id = $request->get('id');
        $card = $dormitoryCardRepository->findOneBy(['id' => $card_id]);
        $form = $this->createForm(UpdateDormitoryCardType::class,$card);
        $form->handleRequest($request);
        if ($form->isSubmitted() && $form->isValid()) {
            $entityManager->flush();
            $url = $adminUrlGenerator->setDashboard($user->getDashboard())->setRoute('app_dormitory_card_show')->generateUrl();
            return $this->redirect($url);
        }
        return $this->render('basic_form.html.twig', [
            'form' => $form,
            'templateUrl' => null,
        ]);
    }
}
