<?php

namespace App\Controller\Cron;

use Exception;
use Symfony\Bundle\FrameworkBundle\Console\Application;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\NullOutput;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\HttpKernel\KernelInterface;

class CronController extends AbstractController
{
    private KernelInterface $kernel;

    public function __construct(KernelInterface $kernel)
    {
        $this->kernel = $kernel;
    }
    /**
     * @throws Exception
     */
    protected function process(string $command): Response
    {
        $application = new Application($this->kernel);
        $application->setAutoExit(false);

        //for developing purpose, to see "dump" this code can be used...
        //$command = $application->find('messenger:consume');
        //$commandTester = new CommandTester($command);
        //$commandTester->execute($arguments);

        // You can use NullOutput() if you don't need the output
        $input = new ArrayInput(['command' => $command]);
        $output = new NullOutput();
        $application->run($input, $output);
        return new Response();
    }
}