<?php

namespace App\Controller\Cron;

use Exception;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
#[Route('/cron', name: 'cron_')]
class NotificationController extends CronController
{
    // cron every day approx. every 2 minutes
    /**
     * @throws Exception
     */
    #[Route('/send-push', name: 'send_push')]
    public function sendPushNotifications(): Response
    {
        $this->process('app:send-push-notifications');
        return new Response();
    }

    /**
     * @throws Exception
     */
    #[Route('/send-mail', name: 'send_mail')]
    public function sendMails(): Response
    {
        $this->process('app:send-mails');
        return new Response();
    }
    /**
     * @throws Exception
     */
    #[Route('/create-notification-unsent-messages', name: 'notify_unsent_messages')]
    public function createNotificationForUnsentMessages(): Response
    {
        $this->process('app:notify-send-message');
        return new Response();
    }
}