<?php

namespace App\Controller;

use App\Form\DataTransformer\FileToGroupMeetingDataTransformer;
use App\Form\DataTransformer\FileToIndividualMeetingDataTransformer;
use App\Form\DataTransformer\FileToScheduleDataTransformer;
use App\Form\DataTransformer\FileToStudentDataTransformer;
use App\Form\DataTransformer\FileToTrainingDataTransformer;
use App\Services\FileResponse;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[Route('/stiahnut', name: 'app_download_')]
#[IsGranted(new Expression('is_granted("ROLE_ADMIN") or is_granted("ROLE_EDUCATOR")'))]
class DownloadController extends AbstractController
{
    #[Route('/rozvrh', name: 'template_schedule')]
    #[IsGranted('ROLE_ADMIN')]
    public function downloadScheduleTemplate(): Response
    {
        $csvContent = $this->setContent(FileToScheduleDataTransformer::getKeys());
        return FileResponse::get($csvContent, 'schedule_template.csv','text/csv');
    }
    #[Route('/studenti', name: 'template_students')]
    public function downloadStudentsTemplate(): Response
    {
        $csvContent = $this->setContent(FileToStudentDataTransformer::getKeys());
        return FileResponse::get($csvContent, 'students_template.csv','text/csv');
    }
    #[Route('/individualne-stretnutia', name: 'template_individual_meeting')]
    public function downloadIndividualMeetingTemplate(): Response
    {
        $csvContent = $this->setContent(FileToIndividualMeetingDataTransformer::getKeys());
        return FileResponse::get($csvContent, 'individual_meeting_template.csv','text/csv');
    }
    #[Route('/skupinove-stretnutia', name: 'template_group_meeting')]
    public function downloadGroupMeetingTemplate(): Response
    {
        $csvContent = $this->setContent(FileToGroupMeetingDataTransformer::getKeys());
        return FileResponse::get($csvContent, 'group_meeting_template.csv','text/csv');
    }
    #[Route('/treningy', name: 'template_trainings')]
    public function downloadTrainingsTemplate(): Response
    {
        $csvContent = $this->setContent(FileToTrainingDataTransformer::getKeys());
        return FileResponse::get($csvContent, 'trainings_template.csv','text/csv');
    }
    private function getBomString(): string
    {
        // Byte Order Mark for UTF-8 encoding
        return chr(0xEF) . chr(0xBB) . chr(0xBF);
    }
    private function setContent(array $columnNames): string
    {
        $csvContent = implode(',', $columnNames) . "\n";
        return $this->getBomString() . $csvContent;
    }
}
