<?php

namespace App\Controller\Educator\Crud;

use App\Controller\Admin\Crud\CoachCrudController;
use App\Entity\Coach;
use App\Entity\User;
use EasyCorp\Bundle\EasyAdminBundle\Config\Action;
use EasyCorp\Bundle\EasyAdminBundle\Config\Actions;
use EasyCorp\Bundle\EasyAdminBundle\Config\Crud;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted(User::ROLE_EDUCATOR)]
class CoachCrudEducatorController extends CoachCrudController
{
    public static function getEntityFqcn(): string
    {
        return Coach::class;
    }
    public function configureActions(Actions $actions): Actions
    {
        return parent::configureActions($actions)
            ->remove(Crud::PAGE_DETAIL, Action::DELETE)
            ->remove(Crud::PAGE_INDEX, Action::DELETE)
            ->disable(Action::BATCH_DELETE, Action::DELETE)
            ;
    }

}
