<?php

namespace App\Controller\Educator\Crud;

use App\Controller\Admin\Crud\MasterTeacherCrudController;
use App\Entity\MasterTeacher;
use App\Entity\User;
use EasyCorp\Bundle\EasyAdminBundle\Config\Action;
use EasyCorp\Bundle\EasyAdminBundle\Config\Actions;
use EasyCorp\Bundle\EasyAdminBundle\Config\Crud;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted(User::ROLE_EDUCATOR)]
class MasterTeacherCrudEducatorController extends MasterTeacherCrudController
{
    public static function getEntityFqcn(): string
    {
        return MasterTeacher::class;
    }
    public function configureActions(Actions $actions): Actions
    {
        return parent::configureActions($actions)
            ->remove(Crud::PAGE_DETAIL, Action::DELETE)
            ->remove(Crud::PAGE_INDEX, Action::DELETE)
            ->disable(Action::BATCH_DELETE, Action::DELETE)
            ;
    }
}
