<?php

namespace App\Controller\Educator\Crud;

use App\Controller\Admin\Crud\MeetingCrudController;
use App\Entity\Meeting;
use App\Entity\User;
use EasyCorp\Bundle\EasyAdminBundle\Field\AssociationField;
use EasyCorp\Bundle\EasyAdminBundle\Field\CollectionField;
use EasyCorp\Bundle\EasyAdminBundle\Field\DateTimeField;
use EasyCorp\Bundle\EasyAdminBundle\Field\FormField;
use EasyCorp\Bundle\EasyAdminBundle\Field\IdField;
use EasyCorp\Bundle\EasyAdminBundle\Field\IntegerField;
use EasyCorp\Bundle\EasyAdminBundle\Field\TextField;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted(User::ROLE_EDUCATOR)]
class MeetingCrudEducatorController extends MeetingCrudController
{
    public static function getEntityFqcn(): string
    {
        return Meeting::class;
    }
    public function createEntity(string $entityFqcn): Meeting
    {
        $meeting = new Meeting();
        $educator = $this->getUser()->getEducator();
        $meeting->setEducator($educator);

        return $meeting;
    }

    public function configureFields(string $pageName): iterable
    {
        return [
            FormField::addTab('dashboard.general_info'),
            IdField::new('id')
                ->setLabel('entity.id')
                ->hideOnForm(),
            AssociationField::new('educator')
                ->setLabel('entity.educator.singular_name')
                ->setCrudController(EducatorCrudEducatorController::class)
                ->setColumns('col-12')
                ->hideOnForm()
                ->autocomplete()
                ->setRequired(true),
            DateTimeField::new('plannedDate')
                ->setLabel('entity.meeting.planned_date')
                ->setRequired(true),
            TextField::new('educatorNote')
                ->setLabel('entity.meeting.educator_note')
                ->setColumns('col-12')
                ->hideOnIndex(),
            TextField::new('studentNote')
                ->setLabel('entity.meeting.student_note')
                ->setColumns('col-12')
                ->hideOnIndex(),
            IntegerField::new('doorNumber')
                ->setLabel('entity.meeting.door_number')
                ->setColumns('col-12')
                ->setRequired(true),
            TextField::new('isPresent')
                ->setLabel('entity.meeting.is_present')
                ->setFormTypeOption('mapped', false)
                ->hideOnForm()
                ->setValue('0')
                ->formatValue(function ($value, $entity) {
                    return $this->countPresentStudentsByMeetingId($entity);
                }),

            TextField::new('studentsCount')
                ->setLabel('entity.meeting.count')
                ->setFormTypeOption('mapped', false)
                ->hideOnForm()
                ->setValue('0')
                ->formatValue(function ($value, $entity) {
                    return $this->countAllStudentsByMeetingId($entity);
                }),
            FormField::addTab('entity.student.plural_name'),
            CollectionField::new('meetingAttendances')
                ->setLabel('entity.meeting.attendance')
                ->hideOnIndex()
                ->setTemplatePath('admin/show_meeting_students.html.twig'),
        ];
    }
}