<?php

namespace App\Controller\Educator\Crud;

use App\Controller\Admin\Crud\RoomCrudController;
use App\Entity\Room;
use App\Entity\User;
use EasyCorp\Bundle\EasyAdminBundle\Config\Action;
use EasyCorp\Bundle\EasyAdminBundle\Config\Actions;
use EasyCorp\Bundle\EasyAdminBundle\Config\Crud;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted(User::ROLE_EDUCATOR)]
class RoomCrudEducatorController extends RoomCrudController
{
    public static function getEntityFqcn(): string
    {
        return Room::class;
    }
    public function configureActions(Actions $actions): Actions
    {
        return parent::configureActions($actions)
            ->remove(Crud::PAGE_DETAIL, Action::EDIT)
            ->remove(Crud::PAGE_INDEX, Action::EDIT)
            ->remove(Crud::PAGE_INDEX, Action::NEW)
            ->disable(Action::EDIT, Action::NEW)
            ;
    }

}
