<?php

namespace App\Controller\Educator\Crud;

use App\Controller\Admin\Crud\SchoolCrudController;
use App\Entity\School;
use App\Entity\User;
use EasyCorp\Bundle\EasyAdminBundle\Config\Action;
use EasyCorp\Bundle\EasyAdminBundle\Config\Actions;
use EasyCorp\Bundle\EasyAdminBundle\Config\Crud;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted(User::ROLE_EDUCATOR)]
class SchoolCrudEducatorController extends SchoolCrudController
{
    public static function getEntityFqcn(): string
    {
        return School::class;
    }
    public function configureActions(Actions $actions): Actions
    {
        return parent::configureActions($actions)
            ->remove(Crud::PAGE_DETAIL, Action::EDIT)
            ->remove(Crud::PAGE_DETAIL, Action::DELETE)
            ->remove(Crud::PAGE_INDEX, Action::DELETE)
            ->remove(Crud::PAGE_INDEX, Action::EDIT)
            ->remove(Crud::PAGE_INDEX, Action::NEW)
            ->disable(Action::BATCH_DELETE, Action::EDIT, Action::DELETE, Action::NEW)
            ;
    }
}
