<?php

namespace App\Controller\Educator\Crud;

use App\Controller\Admin\Crud\EducatorCrudController;
use App\Controller\Admin\Crud\StudentNoteCrudController;
use App\Entity\StudentNote;
use App\Entity\User;
use DateTimeImmutable;
use EasyCorp\Bundle\EasyAdminBundle\Config\Action;
use EasyCorp\Bundle\EasyAdminBundle\Config\Actions;
use EasyCorp\Bundle\EasyAdminBundle\Config\Crud;
use EasyCorp\Bundle\EasyAdminBundle\Field\AssociationField;
use EasyCorp\Bundle\EasyAdminBundle\Field\DateTimeField;
use EasyCorp\Bundle\EasyAdminBundle\Field\IdField;
use EasyCorp\Bundle\EasyAdminBundle\Field\TextField;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted(User::ROLE_EDUCATOR)]
class StudentNoteCrudEducatorController extends StudentNoteCrudController
{
    public static function getEntityFqcn(): string
    {
        return StudentNote::class;
    }
    public function createEntity(string $entityFqcn): StudentNote
    {
        /** @var User $user */
        $user = $this->getUser();
        $studentNote = new StudentNote();
        $studentNote->setEducator($user->getEducator());
        $studentNote->setTime(new DateTimeImmutable());
        return $studentNote;
    }

    public function configureActions(Actions $actions): Actions
    {
        return parent::configureActions($actions)
            ->remove(Crud::PAGE_DETAIL, Action::DELETE)
            ->remove(Crud::PAGE_INDEX, Action::DELETE)
            ->disable(Action::BATCH_DELETE, Action::DELETE, Action::EDIT)
            ;
    }
    public function configureFields(string $pageName): iterable
    {
        $controller = in_array(User::ROLE_ADMIN, $this->getUser()->getRoles()) ? EducatorCrudController::class : EducatorCrudEducatorController::class;

        return [
            IdField::new('id')
                ->setLabel('entity.id')
                ->hideOnForm(),
            AssociationField::new('educator')
                ->setLabel('entity.educator.singular_name')
                ->hideOnForm()
                ->setCrudController($controller)
                ->autocomplete()
                ->setColumns('col-12'),
            AssociationField::new('student')
                ->setLabel('entity.student.singular_name')
                ->setColumns('col-12'),
            DateTimeField::new('time')
                ->setLabel('entity.schedule.time')
                ->hideOnForm()
                ->setColumns('col-12'),
            TextField::new('note')
                ->setLabel('entity.student_note.singular_name')
                ->setColumns('col-12'),
        ];
    }
}
