<?php

namespace App\Controller;

use App\Entity\User;
use App\Repository\StudentRepository;
use App\Serializer\StudentNormalizer;
use App\Services\FileResponse;
use Exception;
use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Http\Attribute\IsGranted;
use Symfony\Component\Serializer\Encoder\CsvEncoder;
use Symfony\Component\Serializer\Serializer;

#[Route(['/export'], name: 'app_export_')]
#[IsGranted(User::ROLE_ADMIN)]
class ExportController extends AbstractController
{
    /**
     * @throws Exception
     */
    #[Route('/studenti', name: 'students')]
    public function exportStudents(StudentRepository $studentRepository): Response
    {
        $result = $studentRepository->findActiveStudentsWithRoom();
        $serializer = new Serializer([new StudentNormalizer()], [new CsvEncoder()]);
        $content = $serializer->serialize($result, 'csv');
        return FileResponse::get($content, 'students.csv','text/csv');
    }
}
