<?php

namespace App\Controller\Guardian\Crud;

use App\Controller\Admin\Crud\StudentCrudController;
use App\Controller\Admin\Crud\WalkOutCrudController;
use App\Controller\Admin\Filter\ChildrenFilter;
use App\Controller\Educator\Crud\StudentCrudEducatorController;
use App\Controller\Educator\Crud\StudentNoteCrudEducatorController;
use App\Entity\Attendance;
use App\Entity\User;
use Doctrine\ORM\QueryBuilder;
use EasyCorp\Bundle\EasyAdminBundle\Collection\FieldCollection;
use EasyCorp\Bundle\EasyAdminBundle\Collection\FilterCollection;
use EasyCorp\Bundle\EasyAdminBundle\Config\Action;
use EasyCorp\Bundle\EasyAdminBundle\Config\Actions;
use EasyCorp\Bundle\EasyAdminBundle\Config\Crud;
use EasyCorp\Bundle\EasyAdminBundle\Config\Filters;
use EasyCorp\Bundle\EasyAdminBundle\Controller\AbstractCrudController;
use EasyCorp\Bundle\EasyAdminBundle\Dto\EntityDto;
use EasyCorp\Bundle\EasyAdminBundle\Dto\SearchDto;
use EasyCorp\Bundle\EasyAdminBundle\Field\AssociationField;
use EasyCorp\Bundle\EasyAdminBundle\Field\DateTimeField;
use EasyCorp\Bundle\EasyAdminBundle\Field\IdField;
use EasyCorp\Bundle\EasyAdminBundle\Field\TextField;
use Symfony\Component\ExpressionLanguage\Expression;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted(User::ROLE_GUARDIAN)]
class WalkOutCrudGuardianController extends WalkOutCrudController
{
    public function createIndexQueryBuilder(SearchDto $searchDto, EntityDto $entityDto, FieldCollection $fields, FilterCollection $filters): QueryBuilder
    {
        return parent::createIndexQueryBuilder($searchDto, $entityDto, $fields, $filters)
            ->leftJoin('entity.student', 'student_query')
            ->leftJoin('student_query.guardians', 'guardian_query')
            ->andWhere('guardian_query.id = :guardian')
            ->setParameter('guardian', $this->getUser()->getGuardian()->getId());
    }
    public function configureFilters(Filters $filters): Filters
    {
        return $filters
            ->add('time')
            ->add(ChildrenFilter::new('student', 'student'))
            ;
    }
    public function configureActions(Actions $actions): Actions
    {
        return parent::configureActions($actions)
            ->remove(Crud::PAGE_DETAIL, Action::EDIT)
            ->remove(Crud::PAGE_DETAIL, Action::DELETE)
            ->remove(Crud::PAGE_INDEX, Action::DELETE)
            ->remove(Crud::PAGE_INDEX, Action::EDIT)
            ->remove(Crud::PAGE_INDEX, Action::NEW)
            ->disable(Action::BATCH_DELETE, Action::DELETE, Action::EDIT, Action::NEW)
            ;
    }

    public function configureFields(string $pageName): iterable
    {
        return [
            IdField::new('id')
                ->setLabel('entity.id')
                ->hideOnForm(),
            DateTimeField::new('time')
                ->setLabel('entity.attendance.time')
                ->setRequired(true)
                ->setColumns('col-12'),
            DateTimeField::new('validUntil')
                ->setLabel('entity.attendance.valid_until')
                ->setRequired(true)
                ->setColumns('col-12'),
            AssociationField::new('student')
                ->setLabel('entity.student.singular_name')
                ->setRequired(true)
                ->setTemplatePath('admin/render_student_without_url.html.twig')
                ->setColumns('col-12'),
            TextField::new('note')
                ->setLabel('entity.attendance.note')
                ->hideOnIndex()
                ->setColumns('col-12'),
        ];
    }
}
