<?php

namespace App\Controller;

use Symfony\Bundle\FrameworkBundle\Controller\AbstractController;
use Symfony\Component\HttpFoundation\Response;
use Symfony\Component\Routing\Annotation\Route;
use Symfony\Component\Security\Core\Exception\TooManyLoginAttemptsAuthenticationException;
use Symfony\Component\Security\Http\Authentication\AuthenticationUtils;

class LoginController extends AbstractController
{
    #[Route('/', name: 'app_login')]
    public function index(AuthenticationUtils $authenticationUtils): Response
    {
        // get the login error if there is one
        $errorMessage = null;
        $error = $authenticationUtils->getLastAuthenticationError();
        if ($error) {
            if ($error instanceof TooManyLoginAttemptsAuthenticationException){
                $errorMessage = 'login_page.too_many_login_attempts';
            }
            else {
                $errorMessage = 'login_page.wrong_login';
            }
        }
        // last username entered by the user
        $email = $authenticationUtils->getLastUsername();

        return $this->render('login/index.html.twig', [
            'email' => $email,
            'error' => $error,
            'errorMessage' => $errorMessage,
        ]);
    }

}
