<?php

namespace App\Controller\Student\Crud;

use App\Controller\Admin\Crud\LeavingHomeCrudController;
use App\Entity\Attendance;
use App\Entity\User;
use EasyCorp\Bundle\EasyAdminBundle\Collection\FieldCollection;
use EasyCorp\Bundle\EasyAdminBundle\Collection\FilterCollection;
use EasyCorp\Bundle\EasyAdminBundle\Config\Action;
use EasyCorp\Bundle\EasyAdminBundle\Config\Actions;
use EasyCorp\Bundle\EasyAdminBundle\Config\Crud;
use EasyCorp\Bundle\EasyAdminBundle\Config\Filters;
use EasyCorp\Bundle\EasyAdminBundle\Dto\EntityDto;
use EasyCorp\Bundle\EasyAdminBundle\Dto\SearchDto;
use EasyCorp\Bundle\EasyAdminBundle\Field\AssociationField;
use EasyCorp\Bundle\EasyAdminBundle\Field\DateTimeField;
use EasyCorp\Bundle\EasyAdminBundle\Field\IdField;
use EasyCorp\Bundle\EasyAdminBundle\Field\TextField;
use Doctrine\ORM\QueryBuilder;
use Symfony\Component\Security\Http\Attribute\IsGranted;

#[IsGranted(User::ROLE_STUDENT)]
class LeavingHomeCrudStudentController extends LeavingHomeCrudController
{
    public function createIndexQueryBuilder(SearchDto $searchDto, EntityDto $entityDto, FieldCollection $fields, FilterCollection $filters): QueryBuilder
    {
        return parent::createIndexQueryBuilder($searchDto, $entityDto, $fields, $filters)
            ->andWhere('entity.student = :student')
            ->setParameter('student', $this->getUser()->getStudent()->getId());

    }
    public function configureFilters(Filters $filters): Filters
    {
        return $filters
            ->add('time')
            ;
    }
    public function configureActions(Actions $actions): Actions
    {
        return parent::configureActions($actions)
            ->remove(Crud::PAGE_DETAIL, Action::EDIT)
            ->remove(Crud::PAGE_DETAIL, Action::DELETE)
            ->remove(Crud::PAGE_INDEX, Action::DELETE)
            ->remove(Crud::PAGE_INDEX, Action::EDIT)
            ->remove(Crud::PAGE_INDEX, Action::NEW)
            ->disable(Action::BATCH_DELETE, Action::DELETE, Action::EDIT, Action::NEW)
            ;
    }

    public function configureFields(string $pageName): iterable
    {
        return [
            IdField::new('id')
                ->setLabel('entity.id')
                ->hideOnForm(),
            DateTimeField::new('time')
                ->setLabel('entity.attendance.time')
                ->setColumns('col-12')
                ->setRequired(true),
            DateTimeField::new('validUntil')
                ->setLabel('entity.attendance.valid_until')
                ->setRequired(true)
                ->setColumns('col-12'),
            AssociationField::new('student')
                ->setLabel('entity.student.singular_name')
                ->setRequired(true)
                ->setTemplatePath('admin/render_student_without_url.html.twig')
                ->setColumns('col-12'),
            TextField::new('note')
                ->setLabel('entity.attendance.note')
                ->hideOnIndex()
                ->setColumns('col-12'),
        ];
    }
}
